\name{arithmetic_progression}
\alias{arithmetic_progression}
\title{
  Arithmetic Progression
}
\description{
  Generates arithmetic progressions of a certain length.
}
\usage{
arithmetic_progression(a, d, n)
}
\arguments{
  \item{a}{starting value, a natural number.}
  \item{d}{difference between entries in the sequence.}
  \item{n}{length of the sequence.}
}
\details{
  An arithmetic progression is a sequence of numbers \eqn{a_n} such that
  the difference between successive terms is a constant \eqn{d}. Arithmetic 
  progressions and the prime numbers they contain play an important role in 
  Algebraic Number Theory.
}
\value{
  A sequence of natural numbers.
}
\references{
  William Stein. Algebraic Number Theory, A Computational Approach.
  November 14, 2012. URL: wstein.org/books/ant/ant.pdf
}
\note{
  The theory of primes in arithmetic progressions is one of the
  cornerstones of Algebraic Number Theory.
}
\seealso{
  \code{\link{polygonal}}
}
\examples{
# All numbers  1 < n < 100 , such that n congruent to 1 modula 23 !
  arithmetic_progression(1, 23, 5)  # or
  N <- 1:100; N[mod(N, 23)==1]      # 1 24 47 70 93

# To generate the arithmetic progression from a to b with d as difference:
# n = floor((b-a)/d)+1
# arithmetic_progression(a, d, n)
  n <- floor((100-1)/23) + 1        # 5
  arithmetic_progression(1, 23, n)  # 1 24 47 70 93

# Primes in arithmetic progressions:
  n1 <- arithmetic_progression(5, 4, 1000)  # 5  9 13 17 21 25 29 ...
  n3 <- arithmetic_progression(3, 4, 1000)  # 3  7 11 15 19 23 27 ...
  length(n1[isPrime(n1)])                   # 269
  length(n1[isPrime(n3)])                   # 280

# Sum of squares of reciprocals of an arithmetic progression:
  a = 7; d = 11; n = 1000
  sum(1/arithmetic_progression(a, d, n)^2)  # 0.0272888
  # = trigamma(a/d)/d^2                     # 0.0272971
}
