% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid_cases_nsw}
\alias{covid_cases_nsw}
\title{Small sample of COVID-19 cases in NSW for testing and demonstration.}
\format{
A data frame with 100 rows and the following columns:
\describe{
\item{postcode}{The postal code}
\item{lhd}{The name of the Local Health District}
\item{lga}{The name of the Local Government Area}
\item{type}{A synthetic disease type/lineage/etc., either A or B}
\item{year}{Year of the case notification}
}
}
\source{
NSW Ministry of Health.
"NSW COVID-19 cases by location."
\url{https://data.nsw.gov.au/data/dataset/covid-19-cases-by-location}, accessed 11 October 2022.

The original dataset is published under the \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0} licence, © State of New South Wales 2020-2022.
}
\usage{
covid_cases_nsw
}
\description{
This subset covers a random selection of entries from 3 LGAs, and ignores the case count field.
}
\examples{
head(covid_cases_nsw)
}
\keyword{datasets}
