% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npnbinom.R
\name{plot.npnbinom}
\alias{plot.npnbinom}
\title{Plotting a nonparametric negative binomial mixture}
\usage{
\method{plot}{npnbinom}(
  x,
  mix,
  beta,
  col = "red",
  add = FALSE,
  components = TRUE,
  main = "npnbinom",
  lwd = 1,
  lty = 1,
  xlab = "Data",
  ylab = "Density",
  ...
)
}
\arguments{
\item{x}{an object of class \code{npnbinom}.}

\item{mix}{an object of class \code{disc}.}

\item{beta}{the structural parameter (not used for a negative
binomial mixture).}

\item{col}{the color of the density curve to be plotted.}

\item{add}{if \code{FALSE}, creates a new plot; if \code{TRUE},
adds the plot to the existing one.}

\item{components}{if \code{TRUE}, also show the support points and
mixing proportions (with vertical lines in proportion).}

\item{main, lwd, lty, xlab, ylab}{arguments for graphical parameters
(see \code{par}).}

\item{...}{arguments passed on to function \code{plot}.}
}
\description{
Function \code{plot.npnbinom} plots a negative
  binomial mixture, along with data.
}
\examples{

mix = disc(pt=c(0.2,0.5), pr=c(0.3,0.7))  # a discrete distribution
x = rnpnbinom(200, 10, mix)
plot(x, mix)
 
}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
likelihood estimate of a mixing distribution. \emph{Journal of the
Royal Statistical Society, Ser. B}, \bold{69}, 185-198.
}
\seealso{
\code{\link[lsei]{nnls}}, \code{\link{cnm}},
  \code{\link{cnmms}}, \code{\link{plot.nspmix}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
\keyword{class}
\keyword{function}
