% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npnbinom.R
\name{npnbinom}
\alias{npnbinom}
\alias{rnpnbinom}
\alias{dnpnbinom}
\alias{pnpnbinom}
\title{Class \code{npnbinom}}
\usage{
npnbinom(v, w=1, size, grouping=TRUE)
rnpnbinom(n, size, mix=disc(0.5))
dnpnbinom(x, mix=disc(0.5), size=NULL, log=FALSE)
pnpnbinom(x, mix=disc(0.5), size=NULL, lower.tail=TRUE, log.p=FALSE)
}
\arguments{
\item{v}{a numeric vector that stores the values of a sample.}

\item{w}{a numeric vector that stores the corresponding
weights/frequencies of the observations.}

\item{size}{number of successful trials (ignored if \code{x} is
an object of class \code{npnbinom}).}

\item{grouping}{logical, to use frequencies (w) for identical
values}

\item{n}{the sample size.}

\item{x}{an object of class \code{npnbinom}, or a numeric vector
(then value of \code{size} must be provided).}

\item{mix}{an object of class \code{disc}.}

\item{log, }{=FALSE, if log-values are to be returned.}

\item{lower.tail, }{=FALSE, if lower.tail values are to be
returned.}

\item{log.p, }{=FALSE, if log probability values are to be
returned.}
}
\description{
Class \code{npnbinom} is used to store data that will be
  processed as those of a nonparametric negative binomial mixture.

Function \code{npnbinom} creates an object of class
\code{npnbinom}, given values and weights/frequencies.

Function \code{rnpnbinom} generates a random sample from a
negative binomial mixture and saves the data as an object of class
\code{npnbinom}.
}
\examples{

mix = disc(pt=c(0.2,0.5), pr=c(0.3,0.7))
(x = rnpnbinom(200, size=10, mix))
dnpnbinom(x, mix, size=10)
pnpnbinom(x, mix, size=10)

}
\references{
Wang, Y. (2007). On fast computation of the non-parametric
  maximum likelihood estimate of a mixing
  distribution. \emph{Journal of the Royal Statistical Society,
  Ser. B}, \bold{69}, 185-198.
}
\seealso{
\code{\link[lsei]{nnls}}, \code{\link{cnm}},
  \code{\link{cnmms}}, \code{\link{plot.nspmix}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
