% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_distinct.R
\name{nest_distinct}
\alias{nest_distinct}
\title{Subset distinct/unique rows within a nested data frame}
\usage{
nest_distinct(.data, .nest_data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{Optional variables to use when determining uniqueness. If there
are multiple rows for a given combination of inputs, only the first row
will be preserved. If omitted, will use all variables.}

\item{.keep_all}{If \code{TRUE}, keep all variables in \code{.nest_data}. If a
combination of \code{...} is not distinct, this keeps the first row of values.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item Rows are a subset of the input but appear in the same order.
\item Columns are not modified if \code{...} is empty or \code{.keep_all} is \code{TRUE}.
Otherwise, \code{nest_distinct()} first calls \code{dplyr::mutate()} to create new
columns within each object in \code{.nest_data}.
\item Groups are not modified.
\item Data frame attributes are preserved.
}
}
\description{
\code{nest_distinct()} selects only unique/distinct rows in a nested data frame.
}
\details{
\code{nest_distinct()} is largely a wrapper for \code{\link[dplyr:distinct]{dplyr::distinct()}} and maintains
the functionality of \code{distinct()} within each nested data frame. For more
information on \code{distinct()}, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% nest_distinct(country_data, country)
gm_nest \%>\% nest_distinct(country_data, country, year)
}
