% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persimon_app_helpers.R
\name{appendInputParams}
\alias{appendInputParams}
\title{Append Input Parameters to persimon_app Simulation Results}
\usage{
appendInputParams(df_results, df_success, input)
}
\arguments{
\item{df_results}{A data frame containing the main simulation results.}

\item{df_success}{A data frame containing the counts of successful model runs.}

\item{input}{A list of input values from the Shiny app, including simulation parameters.}
}
\value{
A data frame combining simulation results, success rates, and input
parameters.
The returned data frame includes:
\itemize{
\item All columns from df_results
\item Success rate columns from df_success (appended with '_success')
\item Input parameters (M1, S1, M2, S2, M3, S3, Sk1, Sk2, Sk3, n_simulations,
nboot, conf_level)
\item A unique RunCode for the simulation
}
}
\description{
This internal function combines simulation results with success rates and
input parameters. It prepares the data for storage in the database by appending
all relevant information from a single simulation run.
}
\details{
This function performs several steps:
\enumerate{
\item Appends '_success' to the column names of df_success (except n1, n2, n3).
\item Combines df_results with the modified df_success.
\item Generates a unique run code for the simulation.
\item Creates a data frame of input parameters.
\item Repeats the input parameters to match the number of rows in the results.
\item Combines all the above into a single data frame.
}
}
\keyword{internal}
