% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_import_field_notes.R
\name{import_field_notes}
\alias{import_field_notes}
\alias{import_fieldnotes}
\title{Import field notes from an Excel spreadsheet}
\usage{
import_field_notes(path, ...)

import_fieldnotes(path, ...)
}
\arguments{
\item{path}{(Character) The full path (including filename) to the Excel spreadsheet.}

\item{...}{Other named arguments that will be passed to \code{\link[readxl:read_excel]{readxl::read_excel()}}.}
}
\value{
A named list of class \code{field_notes}.
}
\description{
'Field notes' in this context is a spreadsheet that records the refinements
that a researcher makes throughout their interview process. This package is
opinionated about what these field notes should look like: use \code{\link[=create_field_notes_template]{create_field_notes_template()}}
to get a template for what the package accepts.
}
\examples{
# An example field notes spreadsheet included with the package.
path_to_notes <- system.file("insect_study/records/refinements.xlsx", package = "novelqualcodes")
print(path_to_notes)

# Importing the spreadsheet
my_refinements <- import_field_notes(path_to_notes)

# Looking at its contents
str(my_refinements, max.level = 1)
print(my_refinements$df)

}
