% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hue_flashlights.R
\name{hue_flashlights}
\alias{hue_flashlights}
\title{Flash all the lights connected to your hub}
\usage{
hue_flashlights(bridge_ip = NULL, username = NULL, flashes = 10,
  flash_red = TRUE, light_name = NULL, file = "~/r_keychain.rds")
}
\arguments{
\item{bridge_ip}{Internal IP address of your hue bridge}

\item{username}{Username for connecting to hue bridge}

\item{flashes}{Number of times to flash the lights on and off}

\item{flash_red}{Do you want the lights to turn red before flashing?}

\item{light_name}{If you want to flash ONE light, give it's name here as a character vector. Name is the actual name 'e.g. hallway', not the id number.}

\item{file}{optional location of the keychain, if using}
}
\description{
This function will flash the lights off and on a specified number of times. Currently,
it will effect all lights connected to the hub.
}
\section{Bugs}{

Code repo: \url{https://github.com/epijim/notifyme}
}
\examples{
\dontrun{hue_flashlights(bridge_ip,username)}
}
\keyword{Hue}
\keyword{R}
\keyword{notify}

