% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{arch.test}
\alias{arch.test}
\title{The ARCH effect test function.}
\usage{
arch.test(y, arch = c("box","Lm"), alpha = 0.05, lag.max = 2)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{arch}{A character string naming the desired  test for checking stationarity. Valid values are
\code{"box"} for the Ljung-Box, and \code{"Lm"} for the Lagrange Multiplier test. The default
value is \code{"box"} for the Augmented Ljung-Box test.}

\item{alpha}{Level of the test, possible values range from 0.01 to 0.1. By default \code{alpha = 0.05}
is used}

\item{lag.max}{an integer with the number of used lags.}
}
\value{
A list with class \code{"h.test"} containing the following components:
 \item{statistic:}{the test statistic.}
 \item{parameter:}{the test degrees freedoms.}
 \item{p.value:}{the p-value for the test.}
 \item{alternative:}{a character string describing the alternative hypothesis.}
 \item{method:}{a character string with the test name.}
 \item{data.name:}{a character string giving the name of the data.}
}
\description{
Performs the Pormanteau Q and Lagrange Multipliers test for homoscedasticity in  a univariate
stationary process. The null hypothesis (H0), is that the process is homoscedastic.
}
\details{
Several different tests are available:
Performs Portmanteau Q and Lagrange Multiplier tests for the null hypothesis that the residuals of
an ARIMA model are homoscedastic. The ARCH test is based on the fact that if the residuals (defined
as \code{e(t)}) are heteroscedastic, the squared residuals (e^2[t]) are autocorrelated.
The first type of test is to examine whether the squares of residuals are a sequence of white noise,
which is called the Portmanteau Q test, and similar to the Ljung-Box test on the squared residuals.
By default, \code{alpha = 0.05} is used to select the more likely hypothesis.
}
\examples{
#  stationary  ar process
y = arima.sim(100,model = list(ar = 0.3))
arch.test(y)

}
\references{
Engle, R. F. (1982). Auto-regressive Conditional Heteroscedasticity
with Estimates of the Variance of United Kingdom Inflation.
\emph{Econometrica}. 50(4), 987-1007.

McLeod, A. I. & W. K. Li. (1984). Diagnostic Checking ARMA Time Series
Models Using Squared-Residual Auto-correlations. \emph{Journal of Time
Series Analysis.} 4, 269-273.
}
\seealso{
\code{\link{normal.test}}, \code{\link{seasonal.test}}, \code{\link{uroot.test}}
}
\author{
Asael Alonzo Matamoros
}
