% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transparent.R
\name{ACE_bounds_posterior}
\alias{ACE_bounds_posterior}
\title{Posterior bounds for the Average Causal Effect (ACE).}
\usage{
ACE_bounds_posterior(n_y0x0z0, n_y1x0z0 = NA, n_y0x1z0 = NA,
  n_y1x1z0 = NA, n_y0x0z1 = NA, n_y1x0z1 = NA, n_y0x1z1 = NA,
  n_y1x1z1 = NA, prior, num.sims = 1000)
}
\arguments{
\item{n_y0x0z0}{Number of individuals with Y=0, X=0, Z=0.
Alternatively, a vector with elements in the order of the arguments.}

\item{n_y1x0z0}{Number of individuals with Y=1, X=0, Z=0.}

\item{n_y0x1z0}{Number of individuals with Y=0, X=1, Z=0.}

\item{n_y1x1z0}{Number of individuals with Y=1, X=1, Z=0.}

\item{n_y0x0z1}{Number of individuals with Y=0, X=0, Z=1.}

\item{n_y1x0z1}{Number of individuals with Y=1, X=0, Z=1.}

\item{n_y0x1z1}{Number of individuals with Y=0, X=1, Z=1.}

\item{n_y1x1z1}{Number of individuals with Y=1, X=1, Z=1.}

\item{prior}{Hyperparameters for the Dirichlet prior for p(y, x | z),
in the order of the arguments.}

\item{num.sims}{Number of Monte Carlo draws from the posterior.}
}
\value{
A data frame with the posterior bounds for the ACE,
   based only on sampled distributions (from the posterior)
   that satisfied the IV inequalites.
}
\description{
The posterior bounds for the Average Causal Effect (ACE) is found
   based on a transparent reparametrization (see reference below),
   using a Dirichlet prior.
   A binary Instrumental Variable (IV) model is assumed here.
}
\examples{
ACE_bounds_posterior(158, 14, 0, 0, 52, 12, 23, 78,
     prior = c( rep(1, 2), rep(0, 2), rep(1, 4)))
ACE_bounds_posterior(158, 14, 0, 0, 52, 12, 23, 78,
     prior = c( rep(1/2, 2), rep(0, 2), rep(1/4, 4)))
\dontrun{
ace.bnds.lipid <- ACE_bounds_posterior(158, 14, 0, 0, 52, 12, 23, 78,
     prior = c( rep(1, 2), rep(0, 2), rep(1, 4)), num.sims = 2e4)
summary(ace.bnds.lipid) }
}
\references{
{Richardson, T. S., Evans, R. J., & Robins, J. M. (2011).
   Transparent parameterizations of models for potential outcomes.
   \emph{Bayesian Statistics, 9, 569-610}.}
}

