% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataGeneration.R
\name{rnsbm}
\alias{rnsbm}
\title{simulation of a graph according the noisy stochastic block model}
\usage{
rnsbm(n, theta, modelFamily = "Gauss", directed = FALSE)
}
\arguments{
\item{n}{number of nodes}

\item{theta}{model parameters of the noisy stochastic block model
\describe{
  \item{pi}{latent block proportions, Q-vector}
  \item{w}{connectivity parameters, N_Q-vector}
  \item{nu0}{parameters of the null distribution}
  \item{nu}{parameters of the alternative distribution}
}}

\item{modelFamily}{probability distribution for the edges. Possible values:
\code{Gauss}, \code{Gamma}, \code{Poisson}}

\item{directed}{indicates if the graph is directed (boolean)}
}
\value{
a list with:
\describe{
  \item{dataMatrix}{simulated matrix from the noisy stochastic block model}
  \item{theta}{model parameters of the noisy stochastic block model}
  \item{latentZ}{underlying latent node memberships}
  \item{latentAdj}{underlying latent binary graph}
}
}
\description{
simulation of a graph according the noisy stochastic block model
}
\examples{
n <- 10
Q <- 2
theta <- list(pi= rep(1/Q,Q), nu0=c(0,1))
theta$nu <- matrix(c(-2,10,-2, 1,1,1),nrow=Q*(Q+1)/2,ncol=2)
theta$w <- c(.5, .9, .3)
obs <- rnsbm(n, theta, modelFamily='Gauss')
obs
}
