% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{EV.tctI}
\alias{EV.tctI}
\title{Expected Values of the Type I cell-specific tests}
\usage{
EV.tctI(ct)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}
}
\value{
A \code{matrix} of the expected values of Type I cell-specific tests.
}
\description{
Returns a \code{matrix} of same dimension as, \code{ct}, 
whose entries are the expected values
of the Type I cell-specific test statistics, \eqn{T^I_{ij}}. 
The row and column names are inherited from \code{ct}. 
These expected values are valid under RL or CSR.

See also (\insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}) 
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

EV.tctI(ct)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{EV.tct}}, \code{\link{tct}} and \code{\link{EV.nnct}}
}
\author{
Elvan Ceyhan
}
