% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nndiagram_nodeCoverup.R
\name{nndiagram_nodeCoverup}
\alias{nndiagram_nodeCoverup}
\title{Producing 'LaTeX' Code for Drawing Neural Network Diagrams with Some Neurons being Covered-up}
\usage{
nndiagram_nodeCoverup(
  input,
  hidden,
  node.coverup = NULL,
  title = NULL,
  color = "black",
  alpha = 1,
  layer.sep = 2.5,
  layer.label = NULL,
  input.label = NULL,
  output.label = NULL,
  suppress = FALSE
)
}
\arguments{
\item{input}{a positive integer that specifies the number of input neurons.}

\item{hidden}{a positive integer vector that specifies the number of neurons on each hidden layer. For example, c(6,6,6) specifies that there are 3 hidden layers and 6 neurons on each hidden layer. Non-positive and non-integer numbers are not allowed.}

\item{node.coverup}{an optional positive integer vector that specifies the index of neurons users hope to cover up with lighter color. Neurons are counted from top to bottom and from left to right. For example, in a neural network with \code{input=3}
and \code{hidden=c(6,6,6)}, \code{node.coverup=c(4,10)} means that the user needs to cover up the first neuron on both the first and second hidden layer. Default is \code{NULL}.}

\item{title}{an optional character that specifies the main title of diagram. Default is \code{NULL}.}

\item{color}{an optional character that specifies the color of lines. Default is \code{"black"}.}

\item{alpha}{an optional numeric value between 0 and 1 that specifies the opacity of lines. \code{1} indicates lines to be opaque, and \code{0} indicates lines to be transparent. Default is \code{1}.}

\item{layer.sep}{an optional positive numeric value that specifies the distance between layers of a neural network. Default is \code{2.5}.}

\item{layer.label}{an optional character vector that specifies label for each layer, including input, hidden and output layers.}

\item{input.label}{an optional character vector that specifies label for each input neuron.}

\item{output.label}{an optional character that specifies label for output neuron.}

\item{suppress}{an optional logical value that specifies whether \code{nndiagram_nodeCoverup} should suppress the output of 'LaTeX' code to be directly printed on console. Default is \code{FALSE}.}
}
\value{
\code{nndiagram_nodeCoverup} uses \code{cat()} to print out 'LaTeX' code on console, if not suppressed. Also, \code{nndiagram_nodeCoverup} saves the same output as a character vector invisibly, so users could use \code{cat()} to print it out later at their demand, as shown in Examples.
The \code{nndiagram_nodeCoverup} 'LaTeX' output can be directly copied and pasted to produce neural network diagram in any 'LaTeX' editor.
}
\description{
The \code{nndiagram_nodeCoverup} command is used to produce 'LaTeX' code for drawing well-formatted neural network diagrams, some neurons of which users hope to cover up with lighter color.
To make the code work in a 'LaTeX' editor, users need to install and import the 'TeX' package \href{https://www.overleaf.com/learn/latex/TikZ_package}{TikZ} in the setting of 'TeX' file. Syntax of importing this package is included in the output of function.
}
\note{
This package is an ongoing project, and more functions will be added in the future, such as those to produce pdf version of diagrams or convert handdrawing neural network diagrams to computerized ones. Collaborations are sincerely welcome.
Comments and suggestions are always highly appreciated.
}
\examples{
# A neural network with 3 neurons on input layer, 6 neurons on each of 3 hidden layers,
# and 1 neuron on output layer. All other arguments are default, so no neuron is
# drawn with lighter color.
nndiagram_nodeCoverup(input=3, hidden=c(6,6,6))

# Same as the first example but neurons indexed with 4 and 11 are designed to be drawn
# with lighter color.
nndiagram_nodeCoverup(input=3, hidden=c(6,6,6), node.coverup=c(4,10))

# Same as the first example but distance between layers is defined to be smaller.
nndiagram_nodeCoverup(input=3, hidden=c(6,6,6), layer.sep=1.5)

# Suppress the output of 'LaTeX' code to be directly printed on the console and save the output
# to an object, which can be printed later at demand.
nnd_nodeCoverup <- nndiagram_nodeCoverup(input=3, hidden=c(6,6,6), suppress=TRUE)
cat(paste(nnd_nodeCoverup,"\n"))
}
\seealso{
\link{nndiagram}; \link{nndiagram_oversize}; \link{activation_curve}.
}
\author{
Chencheng Fang, Bonn Graduate School of Economics, University of Bonn. Email: \email{ccfang@uni-bonn.de}
}
