% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_graphcal.R
\name{run_graphcal}
\alias{run_graphcal}
\title{Run graphical analysis of pharmacokinetic parameters}
\usage{
run_graphcal(
  dat,
  route,
  dose_type = c("first_dose", "repeated_doses", "combined_doses"),
  pooled = NULL,
  pooled_ctrl = pooled_control(),
  ...
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{route}{Route of administration. Must be one of bolus, oral, or infusion.}

\item{dose_type}{Specifies the dosing context of the pharmacokinetic
observations. Classified as first_dose, repeated_doses, or combined_doses
based on whether observed concentrations occur following the first
administration, during repeated dosing, or across both contexts.}

\item{pooled}{Optional pooled dataset. If NULL, pooling is performed internally.}

\item{pooled_ctrl}{Control settings created by \code{pooled_control()} for time binning and pooling.}

\item{...}{Additional arguments passed to graphical calculation functions.}
}
\value{
A list containing graphical estimates of key pharmacokinetic parameters.
}
\description{
Performs graphical estimation of pharmacokinetic parameters based on pooled
concentration–time data and the specified route of administration.
}
\details{
The function pools individual profiles using \code{get_pooled_data()} when needed,
and then applies route-specific graphical methods (\code{graphcal_iv} or \code{graphcal_oral})
to estimate parameters such as clearance, volume of distribution, terminal slope,
and absorption rate constant (for oral data).
}
\examples{
# Example 1 (iv case)
dat <- Bolus_1CPT
dat <- processData(dat)$dat
run_graphcal(dat, route="bolus")

# Example 2 (oral case)
dat <- Oral_1CPT
dat <- processData(dat)$dat
run_graphcal(dat, route="oral")

# Example 3 (infusion case).
# Approximate calculation. only use when the infusion duration is very short

dat <- Infusion_1CPT
dat <- processData(dat)$dat
run_graphcal(dat, route="infusion")

}
\seealso{
\code{\link{graphcal_iv}}, \code{\link{graphcal_oral}}, \code{\link{get_pooled_data}}
}
\author{
Zhonghui Huang
}
