% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_single_point_base.R
\name{run_single_point_base}
\alias{run_single_point_base}
\title{Run adaptive single-point pharmacokinetic analysis}
\usage{
run_single_point_base(
  dat,
  route = c("bolus", "oral", "infusion"),
  half_life = NULL,
  dose_type = NULL,
  pooled_ctrl = pooled_control(),
  ssctrl = ss_control()
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{route}{Route of administration. Must be one of bolus, oral, or infusion.}

\item{half_life}{Optional numeric value for drug half-life. If not provided,
it is estimated from the dataset.}

\item{dose_type}{Specifies the dosing context of the pharmacokinetic
observations. Required when half_life is not provided. Classified as
first_dose, repeated_doses, or combined_doses based on whether observed
concentrations occur following the first administration, during repeated
dosing, or across both contexts.}

\item{pooled_ctrl}{Optional list of control parameters used by \code{get_pooled_data()}
for pooling observations. Defaults to output from \code{pooled_control()}.}

\item{ssctrl}{A list of control parameters generated by
\code{ss_control()} to guide the detection of steady-state observations.}
}
\value{
A list containing:
\itemize{
\item summary: a data frame with trimmed mean clearance and volume of
distribution, and run time information
\item dat: the processed dataset used for analysis
\item cl_df: individual clearance estimates
\item vd_df: individual volume of distribution estimates
}
}
\description{
Implements adaptive single-point pharmacokinetic analysis to calculate
clearance and volume of distribution.
}
\details{
This function integrates clearance and volume estimation into a unified
adaptive workflow, using steady-state pharmacokinetic observations and
trimmed mean statistics to reduce the influence of outliers.
}
\examples{
dat <- Bolus_1CPT
out <- processData(dat)
fdat <- out$dat
route <- out$Datainfo$Value[out$Datainfo$Infometrics == "Dose Route"]
half_life <- get_hf(dat = fdat)$half_life_median
run_single_point_base(dat = fdat, half_life = half_life, route = route)$summary

}
\seealso{
\link{calculate_cl}, \link{calculate_vd},
\link{pooled_control}, \link{ss_control}
}
