% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_model_in_subprocess.R
\name{run_model_in_subprocess}
\alias{run_model_in_subprocess}
\title{Run an nlmixr2 model in an isolated subprocess}
\usage{
run_model_in_subprocess(
  modi,
  dat,
  f,
  saem.control = NULL,
  table.control = NULL,
  max_errors = 100,
  max_wall_time = 86400,
  temp_path = NULL,
  cleanup = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{modi}{Integer. A model index used to generate unique temporary filenames.}

\item{dat}{A data frame containing pharmacokinetic data in standard nlmixr2
format for model fitting.}

\item{f}{An nlmixr2 model function (e.g., generated by \code{ppkmodGen(..., return.func = TRUE)}).}

\item{saem.control}{A \code{saemControl()} object providing estimation settings.}

\item{table.control}{A \code{tableControl()} object controlling table output behavior.}

\item{max_errors}{Integer. Maximum number of detected error messages before
forcibly terminating the subprocess. Default is 100.}

\item{max_wall_time}{Numeric (seconds). Maximum allowed real (wall-clock)
time for the subprocess before termination. Default is 86400 (24 hours).}

\item{temp_path}{Character. Directory where temporary files will be written.
If NULL (default), the system temporary directory \code{tempdir()} is used.
If a non-NULL path is supplied but does not exist, the function aborts with an error.}

\item{cleanup}{Logical. Whether to delete all temporary files upon completion.
Default is TRUE. If FALSE, generated temporary files are preserved for
debugging/troubleshooting.}

\item{verbose}{Logical. If TRUE, progress and diagnostic messages are
printed during subprocess monitoring. Default is TRUE.}
}
\value{
A list with:
\describe{
\item{fit.s}{The fitted nlmixr2 object, or NULL if the subprocess failed.}
\item{loadError}{Logical indicating whether an error occurred (including timeout or crash).}
}
}
\description{
Executes an nlmixr2 model fitting procedure in a separate background R
session using the \pkg{processx} backend. Running the model in an isolated
subprocess prevents the main R session from crashing and allows
monitoring errors, wall-time limits, and controlled output.
}
\details{
The model fitting is executed in an isolated background R process
(via \pkg{processx}) to prevent the main R session from crashing due to
instabilities in long-running nlmixr2/SAEM estimation routines or poorly
specified models. Output and error streams are monitored in real time, and
the subprocess is automatically terminated if either the error count
(\code{max_errors}) or the wall-time limit (\code{max_wall_time}) is
exceeded.

Temporary files used to pass data and retrieve results are stored only in
the session-specific temporary directory (\code{tempdir()}) and are removed
upon completion, ensuring that no files are created in or left behind in the
user's working directory.
}
\examples{
\donttest{
# Example: run a simple nlmixr2 model
pheno <- function() {
  ini({
    tcl <- log(0.008)     # typical clearance
    tv  <- log(0.6)       # typical volume
    eta.cl + eta.v ~ c(1,
                       0.01, 1)  # interindividual variability
    add.err <- 0.1        # residual variability
  })

  model({
    cl <- exp(tcl + eta.cl)
    v  <- exp(tv  + eta.v)
    ke <- cl / v
    d/dt(A1) = -ke * A1
    cp = A1 / v
    cp ~ add(add.err)
  })
}
 run_model_in_subprocess(
    modi = 1,
    dat = pheno_sd,
    f = pheno,
    saem.control = nlmixr2est::saemControl(
      seed = 1234,
      nBurn = 100,
      nEm = 100,
      logLik = TRUE
    )
  )
}
}
\author{
Zhonghui Huang
}
