% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{fitness}
\alias{fitness}
\title{Evaluate fitness of a population pharmacokinetic model}
\usage{
fitness(
  search.space = "ivbase",
  fit = NULL,
  dat = NULL,
  penalty.control = penaltyControl(),
  objf = "BIC"
)
}
\arguments{
\item{search.space}{Character, one of "ivbase" or "oralbase". Default is "ivbase".}

\item{fit}{Data frame. Model summary from tools such as
\code{get.mod.lst()}, with parameter estimates and diagnostics.}

\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{penalty.control}{List created using \code{penaltyControl()}, including:
\describe{
\item{penalty.value}{Numeric. Default penalty multiplier used in
binary violations.}
\item{step.penalties}{Numeric vector or list. Penalties applied to
step violations (mild, severe).}
\item{bounds}{List of parameter lower/upper bounds, typically from
\code{param.bounds()}.}
\item{thresholds}{Named list of diagnostic constraints (e.g., RSE,
shrinkage). Each contains a method ("binary" or "step") and the
corresponding threshold or step levels.}
\item{penalty.terms}{Character vector of constraint categories to
penalize. Valid terms include "theta", "rse", "omega",
"shrinkage", "sigma", "correlation", "covariance", and "total".}
}}

\item{objf}{Character. Column name in fit used as the base objective
function (e.g., "AIC", "BIC", "OBJFV").}
}
\value{
A data frame extending fit with the following:
\itemize{
\item flag.* columns: indicators of constraint violations
(0 = no violation, 1 = mild, 2 = severe).
\item count.constraint.* columns: number of violations per
constraint type.
\item fitness: penalized objective function value, computed from the
specified objf plus applicable penalties.
}
}
\description{
Evaluates the quality of a fitted model based on parameter
bounds and diagnostic thresholds.
}
\examples{
\donttest{
# Fit a model (using nlmixr2)
pheno <- function() {
  ini({
    tcl <- log(0.008)
    tv <-  log(0.6)
    eta.cl + eta.v ~ c(1,
                       0.01, 1)
    add.err <- 0.1
  })
  model({
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    ke <- cl / v
    d/dt(A1) = - ke * A1
    cp = A1 / v
    cp ~ add(add.err)
  })
}
fit <- nlmixr2est::nlmixr2(pheno, pheno_sd, "saem", control = list(print = 0),
              table = list(cwres = TRUE, npde = TRUE))
Store. <- get.mod.lst(fit.s = fit, 1)
 fitness(fit = Store.,dat = pheno_sd)
}

}
\seealso{
\code{\link{penaltyControl}()}, \code{\link{param.bounds}()}.
}
\author{
Zhonghui Huang
}
