% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_coral_plots.R
\name{build_coral_plots}
\alias{build_coral_plots}
\title{Build coral plot layout (nodes + edges) from a parsed rules object}
\usage{
build_coral_plots(
  parsed,
  lhs_sort_metric = c("confidence", "support", "lift"),
  bin_breaks = NULL,
  bin_digits = 3
)
}
\arguments{
\item{parsed}{A list as returned by `parse_rules()`, containing components
`items` and `rules` with the schema above.}

\item{lhs_sort_metric}{character; how to order items **within each LHS path**
when building the layout. One of `"confidence"`, `"support"`, `"lift"`.
Typically interpreted as **descending** by the chosen metric.}

\item{bin_breaks}{Optional named list of numeric break vectors used to bin numeric features
(e.g., `list(Age = c(0, 18, 30, 50, Inf))`). If `NULL`, bins are inferred later
(and may be provided to the renderer via `bin_legend`).}

\item{bin_digits}{Integer number of decimal places used when formatting numeric
interval labels (e.g., `[0.405,0.485)`). Default is `3`.}
}
\value{
A list with components:
- `nodes`: `data.frame` of node geometry and labels,
- `edges`: `data.frame` of edge geometry and attached metrics,
- `grid_size`: integer grid side length used to arrange corals.
- `bin_legend`: data.frame (or NULL) mapping feature -> bin index -> interval.
}
\description{
Produces the node and edge layout consumed by `render_coral_rgl()` or `render_coral_rgl_experimental()`.
Given a parsed association-rules object (from `parse_rules()`), this function
groups rules by RHS itemset (one coral per unique RHS), arranges those corals
on a square grid, and emits geometry and metadata for drawing.

**Input expectations (`parsed`)**
- `parsed$items`: `data.frame` with at least
  `item_id` (integer, **0-based**), `label` (character).
- `parsed$rules`: `data.frame` with at least
  `support`, `confidence`, `lift` (numeric) and
  `lhs_item_ids`, `rhs_item_ids` (list-columns of **0-based** integer vectors).
}
\details{
**Grid sizing.** The number of corals (`n_plots`) is computed as the number of
distinct, non-empty RHS itemsets across rules. An RHS itemset’s display label
is recomposed by joining the `items$label` values for its `rhs_item_ids`
(comma-separated). The grid is arranged as a near-square:
`grid_size = ceiling(sqrt(n_plots))`, with a minimum of 1.

The heavy lifting (node positions, radii, edge routing) is delegated to the
C++ backend `build_layout_cpp()`, which receives the `parsed` object, the
computed `grid_size`, and the chosen `lhs_sort_metric`.

**Output schema (for `render_coral_rgl()`).**
- `nodes` includes (at least): `x`, `z`, `x_offset`, `z_offset`, `radius`,
  `path` (character key), `node_id`, `is_root`, `coral_id`, `interval_brackets`, `bin_index`
   and optionally `item`, `feature`, `step`,
  `interval_label`, `interval_label_short`.
- `edges` includes (at least): `x`, `y`, `z`, `x_end`, `y_end`, `z_end`,
  `parent_path`, `child_path`, and the rule metrics `support`, `confidence`, `lift`.
  (Initial `y`/`y_end` are typically on the base plane; vertical styling can be
  added later by `render_coral_rgl()` via `y_scale`/jitter.)

**Indexing note.** Item identifiers remain **0-based** as produced by
`parse_rules()` for cross-language stability.
}
