% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{eval_dcsbm_like}
\alias{eval_dcsbm_like}
\title{Log likelihood of a DCSBM (fast with poi = TRUE)}
\usage{
eval_dcsbm_like(A, z, poi = TRUE, eps = 1e-06)
}
\arguments{
\item{A}{adjacency matrix}

\item{z}{label vector}

\item{poi}{whether to use Poisson version of likelihood}

\item{eps}{truncation threshold for the Bernoulli likelihood,
used when parameter phat is close to 1 or 0.}
}
\value{
log likelihood of a DCSBM
}
\description{
Compute the log likelihood of a DCSBM, using estimated parameters
B, theta based on the given label vector
}
\details{
The log likelihood is calculated by
\deqn{\ell(\hat B,\hat \theta, \hat \pi, \hat z \mid A) =
\sum_i \log \hat \pi_{z_i} + \sum_{i < j} \phi(A_{ij};\hat \theta_i \hat \theta_j \hat B_{\hat{z}_i \hat{z}_j} )}
where \eqn{\hat B}, \eqn{\hat \theta} is calculated by \link{estim_dcsbm},
\eqn{\hat{\pi}_k} is the proportion of nodes in community k.
}
\seealso{
\link{eval_dcsbm_loglr}, \link{eval_dcsbm_bic}
}
\keyword{estimation}
