% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/X_ellips2ned.R
\name{X_ellips2ned}
\alias{X_ellips2ned}
\title{Transform position from ellipsoidal to NED coordinates}
\usage{
X_ellips2ned(x, x_o = NULL)
}
\arguments{
\item{x}{An object of class \code{trajectory} in "ellipsoidal" system or a matrix of position data with latitude, longitude, and altitude}

\item{x_o}{Origin of the fixed Cartesian NED frame expressed in ellipsoidal coordinates}
}
\value{
An object of class \code{trajectory} in "NED" system or a matrix of position data with x_N, x_E, and x_D, according to the type of input \code{x}
}
\description{
Transform position from ellipsoidal coordinates to a fixed Cartesian NED frame
}
\examples{

library(navigation)
data("example_1_traj_ellipsoidal")
traj_ellips <- make_trajectory(example_1_traj_ellipsoidal, system = "ellipsoidal")
plot(traj_ellips)
plot(traj_ellips, threeD = TRUE)
traj_ned <- X_ellips2ned(traj_ellips, x_o = example_1_traj_ellipsoidal[1, -1])
plot(traj_ned)

}
\author{
Davide Cucci, Lionel Voirol, Mehran Khaghani, Stéphane Guerrier
}
