% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{handler_directory}
\alias{handler_directory}
\title{Create Static Directory Handler}
\usage{
handler_directory(path, directory)
}
\arguments{
\item{path}{URI path prefix (e.g., "/static"). Requests to "/static/foo.js"
will serve "directory/foo.js".}

\item{directory}{Path to the directory to serve.}
}
\value{
A handler object for use with \code{\link[=http_server]{http_server()}}.
}
\description{
Creates an HTTP handler that serves files from a directory tree. NNG handles
MIME type detection automatically.
}
\details{
Directory handlers automatically match all paths under the prefix (prefix
matching is implicit). The URI path is mapped to the filesystem:
\itemize{
\item Request to "/static/css/style.css" serves "directory/css/style.css"
\item Request to "/static/" serves "directory/index.html" if it exists
}

Note: The trailing slash behavior depends on how clients make requests.
A request to "/static" (no trailing slash) will not automatically redirect
to "/static/". Consider using \code{\link[=handler_redirect]{handler_redirect()}} if you need this behavior.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
h <- handler_directory("/static", "www/assets")
\dontshow{\}) # examplesIf}
}
