print.naive_bayes <- function (x, ...) {

    model <- "Naive Bayes"
    n_char <- getOption("width") - 3
    str_left_right <- paste0(rep("=", ceiling((n_char - nchar(model)) / 2)),
                             collapse = "")
    str_full <- paste0(str_left_right, " ", model, " ",
                       ifelse(n_char %% 2 != 0, "=", ""), str_left_right)
    len <- nchar(str_full)
    l <- paste0(rep("-", len), collapse = "")
    cat("\n")
    cat(str_full, "\n", "\n", "Call:", "\n", sep = "")
    print(x$call)
    cat("\n")
    cat(l, "\n", "\n")
    cat("Laplace smoothing: ", x$laplace, sep = "")
    cat("\n")
    cat("\n")
    cat(l, "\n", "\n")
    cat("A priori probabilities:", "\n")
    print(x$prior)
    cat("\n")
    cat(l, "\n", "\n")
    cat("Tables:", "\n\n")
    tabs <- x$tables
    n <- length(x$tables)
    indices <- seq_len(min(5,n))
    tabs <- tabs[indices]
    print(tabs)
    if (n > 5) {
        cat("\n\n")
        cat("# ... and", n - 5, ifelse(n - 5 == 1, "more table\n\n", "more tables\n\n"))
        cat(l)
    }
    cat("\n\n")
}
