% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_learners.R
\name{lnr_heteroskedastic_density}
\alias{lnr_heteroskedastic_density}
\title{Conditional Density Estimation with Heteroskedasticity}
\usage{
lnr_heteroskedastic_density(
  data,
  formula,
  mean_lnr,
  var_lnr,
  mean_lnr_args = NULL,
  var_lnr_args = NULL,
  density_args = NULL
)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{mean_lnr}{A learner (function) passed in to be trained on the data with
the given formula and then used to predict conditional means for provided
\code{newdata}.}

\item{var_lnr}{A learner (function) passed in to be trained on the squared
error from the \code{mean_lnr} on the given data and then used to predict
the expected variance for the density distribution of the outcome centered
around the predicted conditional mean in the output.}

\item{mean_lnr_args}{Extra arguments to be passed to the \code{mean_lnr}}

\item{var_lnr_args}{Extra arguments to be passed to the \code{var_lnr}}

\item{density_args}{Extra arguments to be passed to the kernel
density smoother \code{stats::density}, especially things like
\code{bw} for specifying the smoothing bandwidth. See \code{?stats::density}.}
}
\value{
a closure (function) that produces density estimates
at the \code{newdata} given according to the fit model.
}
\description{
Conditional Density Estimation with Heteroskedasticity
}
\examples{
# fit a conditional density model with mean model as a randomForest
fit_density_hetero <- lnr_heteroskedastic_density(
  data = mtcars,
  formula = mpg ~ hp,
  mean_lnr = lnr_rf,
  var_lnr = lnr_lm)

# and what we should get back should be predicted densities at the
# observed mpg given the covariates hp
fit_density_hetero(mtcars)

if (requireNamespace("ggplot2", quietly = TRUE)) {
hp_grid <- with(mtcars, seq(min(hp), max(hp), length.out=100))
mpg_grid <- with(mtcars, seq(min(mpg), max(mpg), length.out=100))
mt_grid <- expand.grid(mpg = mpg_grid, hp = hp_grid)
plt_df <- cbind(mt_grid, pred_dens = fit_density_hetero(mt_grid))
require(ggplot2)
ggplot(plt_df, aes(x = hp, y = mpg, fill = pred_dens)) +
geom_tile() +
scale_fill_viridis_c() +
ggtitle("Density Model of MPG given HP")
}
}
