/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class Unit
implements Comparable<Unit> {
    protected int num;
    protected List<Unit> absorbed;

    public Unit(int num) {
        this.num = num;
        this.absorbed = new ArrayList<Unit>();
    }

    public Unit(Unit that) {
        this(that.num);
        this.absorbed = that.getAbsorbed();
    }

    public static List<Unit> extractAbsorbed(Collection<Unit> s) {
        if (s == null) {
            return null;
        }
        ArrayList<Unit> l = new ArrayList<Unit>(s);
        for (Unit u : s) {
            l.addAll(u.getAbsorbed());
        }
        return l;
    }

    public void absorb(Unit unit) {
        this.absorb(unit, true);
    }

    public void absorb(Unit unit, boolean clearUnit) {
        this.absorbed.addAll(unit.getAbsorbed());
        if (clearUnit) {
            unit.clear();
        }
        this.absorbed.add(unit);
    }

    public void setAbsorbed(List<Unit> absorbed) {
        this.absorbed = absorbed;
    }

    public void clear() {
        this.absorbed.clear();
    }

    public List<Unit> getAbsorbed() {
        return new ArrayList<Unit>(this.absorbed);
    }

    public int hashCode() {
        return this.num;
    }

    public int getNum() {
        return this.num;
    }

    public boolean equals(Object o) {
        return o.getClass() == this.getClass() && this.num == ((Unit)o).num;
    }

    @Override
    public int compareTo(Unit u) {
        return Integer.compare(u.getNum(), this.num);
    }
}

