% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_beta.R
\name{cf_logit}
\alias{cf_logit}
\title{Control function for logit model}
\usage{
cf_logit(
  X,
  Y,
  Z,
  alpha = 1,
  nfolds = 10,
  standardize = TRUE,
  use_lasso = FALSE
)
}
\arguments{
\item{X}{Matrix of exposure principal components (N x K)}

\item{Y}{Binary outcome vector (0/1, length N)}

\item{Z}{Genetic instrument matrix (N x J)}

\item{alpha}{Elastic net mixing parameter (1=lasso, 0=ridge)}

\item{nfolds}{Number of cross-validation folds for lambda selection}

\item{standardize}{Standardize variables before fitting}

\item{use_lasso}{Use LASSO regularization in first stage. If FALSE, uses OLS.}
}
\value{
List with gmm_est, gmm_se, variance_matrix, gmm_pval
}
\description{
Control function for logit model
}
