% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{importVCFfiles}
\alias{importVCFfiles}
\title{Import Mutation data from VCF files.}
\usage{
importVCFfiles(vcfFiles, sampleNames = NULL)
}
\arguments{
\item{vcfFiles}{character vector, includes the names of the VCF files to be analyzed}

\item{sampleNames}{character vector with alternative sample names (otherwise, 
VCF file names will be ised to identify each sample).}
}
\value{
a concatenated data.frame with all variants found in the input VCF files. Sample
ID is stored in the "SAMPLEID" column.
}
\description{
Import Mutation data from VCF files. The columns are expected in the following order:
c("CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER", "INFO", "FORMAT"). Optional columns 
can be present to inform about sample ID or other info.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
