% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediation.R
\name{[,mediation_data,ANY,ANY,ANY-method}
\alias{[,mediation_data,ANY,ANY,ANY-method}
\title{Subset a mediation dataset}
\usage{
\S4method{[}{mediation_data,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{An object of class \code{mediation_data} whose samples we want to subset.}

\item{i}{An integer or integer/logical vector specifying the samples to
subset to.}

\item{j}{A placeholder to argree with R's \code{[} function. Never used.}

\item{...}{A placeholder to agree with R's \code{[} function. Never used.}

\item{drop}{A placeholder to agree with R's \code{[} function. Never used.}
}
\value{
A version of the input mediation_data object whose @mediators,
@outcomes, @treatments, and @pretreatments rows have all been subsetted
according to \code{i}.
}
\description{
We can subset samples by indexing into a mediation dataset. It will subsample
all fields -- pretreatments, treatments, mediators, and outcomes. Note that
there is no way to subset columns in this way, since they would be different
across each source.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
exper[1]
exper[1:10]
}
