% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{estimate}
\alias{estimate}
\title{Estimate a Mediation Model}
\usage{
estimate(model, exper)
}
\arguments{
\item{model}{An object of class multimedia containing the estimated mediation
and outcome models whose mediation and outcome predictions we want to
compare.}

\item{exper}{An object of class multimedia_data containing the mediation and
outcome data from which the direct effects are to be estimated.}
}
\value{
A version of the input modified in place so that the @estimates slot
has been filled.
}
\description{
\code{estimate} provides a unified interface to estimate all the models that can
be encapsulated within a \code{multimedia} class. It simply calls the
multimedia object. The resulting estimates can be used for downstream direct
effect estimation.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    estimate(exper)

# example with another dataset
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper) |>
    estimate(exper)

# example with another model
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper, glmnet_model()) |>
    estimate(exper)
}
