% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap Distribution for Estimators}
\usage{
bootstrap(model, exper, fs = NULL, B = 1000, progress = TRUE)
}
\arguments{
\item{model}{An object of class multimedia with specified mediation and
outcome models that we want to re-estimate across B bootstrap samples.}

\item{exper}{An object of class multimedia_data containing the mediation and
outcome data from which the direct effects are to be estimated.}

\item{fs}{The estimators whose bootstrap samples we are interested in. These
are assumed to be a vector of functions (for example, direct_effect or
indirect_effect), and they will each be applied to each bootstrap resample.}

\item{B}{The number of bootstrap samples. Defaults to 1000.}

\item{progress}{A logical indicating whether to show a progress bar.}
}
\value{
stats A list of length B containing the results of the fs applied on
each of the B bootstrap resamples.
}
\description{
Given a mediation model specification, estimators fs, and original dataset
exper, this will re-estimate the mediation model on resampled versions of
exper and apply each estimator in fs to construct bootstrap distributions
associated wtih those estimators.
}
\examples{
# example with null data. We set B to 5 just to execute quickly -- it's not
# actually a practical choice of B
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    bootstrap(exper, B = 5)

# example with another dataset
exper <- demo_spline(n_samples = 100, tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
samples <- multimedia(exper, rf_model(num.trees = 1e3)) |>
    bootstrap(exper, B = 5)
ggplot2::ggplot(samples$direct_effect) +
    ggplot2::geom_histogram(
        ggplot2::aes(direct_effect, fill = indirect_setting),
        bins = 15
    ) +
    ggplot2::facet_wrap(~outcome, scales = "free")
}
