% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{residualDiagnostics.merMod}
\alias{residualDiagnostics.merMod}
\title{residualDiagnostics methods for merMod objects}
\usage{
\method{residualDiagnostics}{merMod}(
  object,
  ev.perc = 0.001,
  robust = FALSE,
  distr = "normal",
  standardized = TRUE,
  cut = 8L,
  quantiles = TRUE,
  ...
)
}
\arguments{
\item{object}{An object with class \code{\link[lme4]{merMod-class}}. Currently only
\code{\link[lme4]{lmer}} models are supported.}

\item{ev.perc}{The extreme value percentile to use. Defaults to
.001.}

\item{robust}{A logical value, whether to use robust estimates or not.
Defaults to \code{FALSE}.}

\item{distr}{A character string specifying the assumed distribution.
Currently \dQuote{normal}, but may expand in the future if
\code{\link[lme4]{glmer}} models are supported.}

\item{standardized}{A logical value whether to use standardized
residual values or not. Defaults to \code{TRUE}.}

\item{cut}{An integer, how many unique predicted values
there have to be at least for predicted values to be
treated continuously, otherwise they are treated as discrete values.
Defaults to 8.}

\item{quantiles}{A logical whether to calculate quantiles for the
residuals.  Defaults to \code{TRUE}. If \code{FALSE}, then
do not calculate them. These are based on simple quantiles for
each predicted value if the predicted values are few enough to be
treated discretely. See \code{cut} argument. Otherwise they are
based on quantile regression. First trying smoothing splines,
and falling back to linear quantil regression if the splines
fail. You may also want to turn these off if they are not working well,
or are not of value in your diagnostics.}

\item{...}{Additional arguments. Not currently used.}
}
\value{
A logical (\code{\link[JWileymisc]{is.residualDiagnostics}}) or
  a residualDiagnostics object (list) for
  \code{\link[JWileymisc]{as.residualDiagnostics}} and 
  \code{\link[JWileymisc]{residualDiagnostics}}.
}
\description{
residualDiagnostics methods for merMod objects
}
\examples{
library(JWileymisc)
sleep[1,1] <- NA
m <- lme4::lmer(extra ~ group + (1 | ID), data = sleep)

residualDiagnostics(m)$Residuals

#  gm1 <- lme4::glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
#    data = lme4::cbpp, family = binomial)
# residualDiagnostics(gm1) ## should be an error

rm(m, sleep)

}
