% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{acfByID}
\alias{acfByID}
\title{Estimate the autocorrelation by unit (ID)}
\usage{
acfByID(
  xvar,
  timevar,
  idvar,
  data,
  lag.max = 10L,
  na.function = c("na.approx", "na.spline", "na.locf"),
  ...
)
}
\arguments{
\item{xvar}{A character string giving the variable name of
the variable to calculate autocorrelations on.}

\item{timevar}{A character string giving the variable name of
the time variable.}

\item{idvar}{A character string giving the variable name of
the ID variable.  Can be missing if only one time series
provided, in which case one will be created.}

\item{data}{A data.table containing the variables
used in the formula.  This is a required argument.
If a data.frame, it will silently coerce to a data.table.
If not a data.table or data.frame, it will attempt to coerce,
with a message.}

\item{lag.max}{An integer of the maximum lag to estimate. Must be
equal to or greater than the number of observations
for all IDs in the dataset.}

\item{na.function}{A character string giving the name of the function
to use to address any missing data.  Functions come from the
\pkg{zoo} package, and must be one of:
\code{\link[zoo]{na.approx}}, \code{\link[zoo]{na.spline}}, \code{\link[zoo]{na.locf}}.}

\item{...}{Additional arguments passed on.}
}
\value{
A data.table of the estimated autocorrelations by ID and lag
}
\description{
This function estimates the autocorrelation over time in a time
series by a higher level unit, given by ID.
}
\examples{
## example 1
dat <- data.table::data.table(
  x = sin(1:30),
  time = 1:30,
  id = 1)
acfByID("x", "time", "id", data = dat)

## example 2
dat2 <- data.table::data.table(
  x = c(sin(1:30), sin((1:30)/10)),
  time = c(1:30, 1:30),
  id = rep(1:2, each = 30))
dat2$x[4] <- NA

res <- acfByID("x", "time", "id", data = dat2, na.function = "na.approx")

ggplot2::ggplot(res, ggplot2::aes(factor(Lag), AutoCorrelation)) +
  ggplot2::geom_boxplot()

## clean up
rm(dat, dat2, res)
}
\keyword{multivariate}
