% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{snooker}
\alias{snooker}
\title{Snooker data}
\format{
A data.frame with 56910 observations and 11 variables:
\describe{
 \item{\code{y_vec}}{The response values for each observation point.}
 \item{\code{t}}{The observations point locations.}
 \item{\code{n_long}}{Unique identification number for each curve.}
  \item{\code{subject_long}}{Unique identification number for each snooker
     player.}
  \item{\code{word_long}}{Integer specifying the session. 1: Before the
     training, 2: After the training.}
  \item{\code{dim}}{Factor for identifying the univariate dimensions.}
  \item{\code{combi_long}}{Number of the repetition of the snooker shot.}
 \item{\code{covariate.1}}{Skill level of the snooker player. 0: Unskilled,
     1: Skilled.}
 \item{\code{covariate.2}}{Group of the snooker player. 0: Control group,
     1: Treatment group.}
 \item{\code{covariate.3}}{Session indicator. 0: Before the treatment, 1:
     After the treatment.}
 \item{\code{covariate.4}}{Interaction of group and session, i.e. the
     treatment effect indicator.}
}
}
\source{
Enghofer, T. (2014). Überblick über die Sportart Snooker, Entwicklung
   eines Muskeltrainings und Untersuchung dessen Einflusses auf die
   Stoßtechnik. Unpublished Zulassungsarbeit, Technische Universität
   München.
}
\usage{
snooker
}
\description{
The data are part of a study on the impact of a muscular training program on
snooker technique. 25 recreational snooker players were split into treatment
(receiving instructions for a training program) and control group (no
training program). The data set contains the movement trajectories of the
snooker players in two sessions (before and after the training period), where
each snooker player repeated a snooker shot of maximal force six times. The
interest lies in the movement of hand, elbow, and shoulder on a
two-dimensional grid (called X and Y). The trajectories are normalized on a
[0,1] time grid and the beginning of the hand trajectories are centered to
the origin.
}
\keyword{datasets}
