% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{ggscree}
\alias{ggscree}
\title{This function produces a simple scree plot}
\usage{
ggscree(pc, q = 2, guide = TRUE, cumulative = FALSE)
}
\arguments{
\item{pc}{PCA object}

\item{q}{number of principal components to show, default 2 (you should change)}

\item{guide}{logical whether to compute and add
a typical value of the variance, if the data was full-dimensional}

\item{cumulative}{logical whether to draw cumulative variance}
}
\value{
scree a ggplot object
}
\description{
Takes a PCA object returned by \code{prcomp()}, extracts
the standard deviations of the principal components (PC), and
plots these against the PC number. The guidance line assumes that
all of the variables have been standardised prior to PCA.
}
\examples{
data(aflw)
aflw_std <- apply(aflw[,7:35], 2, function(x)
                    (x-mean(x, na.rm=TRUE))/
							       sd(x, na.rm=TRUE))
aflw_pca <- prcomp(aflw_std[,c("goals","behinds",
                               "kicks","disposals")])
ggscree(aflw_pca, q=3)
}
