test_that("sufficient statistics computing works", {
  pc <- table_relative_3d(Z_potts, diag(2), C = 2)
  expect_equal(length(suf_stat(pc, "onepar")), 1)
  expect_equal(length(suf_stat(pc, "oneeach")), 2)
  expect_equal(length(suf_stat(pc, "absdif")), 2*2)
  expect_equal(length(suf_stat(pc, "dif")), 2*4)
  expect_equal(length(suf_stat(pc, "free")), 2*(3*3 -1))
  expect_equal(length(suf_stat(pc, "symmetric")), 2*(3*2 -1))

  Z2 <- Z_potts
  Z2[10,] <- NA
  pc <- table_relative_3d(Z_potts, diag(2), C = 2)
  expect_equal(length(suf_stat(pc, "onepar")), 1)
  expect_equal(length(suf_stat(pc, "oneeach")), 2)
  expect_equal(length(suf_stat(pc, "absdif")), 2*2)
  expect_equal(length(suf_stat(pc, "dif")), 2*4)
  expect_equal(length(suf_stat(pc, "free")), 2*(3*3 -1))
  expect_equal(length(suf_stat(pc, "symmetric")), 2*(3*2 -1))
})

test_that("summarized vector description works", {
  expect_is(vec_description(mrfi(1) + c(3,4), "onepar", 1), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "onepar", 2), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "oneeach", 1), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "oneeach", 1), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "absdif", 1), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "absdif", 2), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "dif", 1), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "dif", 2), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "free", 1), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "free", 2), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "symmetric", 1), "data.frame")
  expect_is(vec_description(mrfi(1) + c(3,4), "symmetric", 2), "data.frame")
  expect_error(vec_description(mrfi(1) + c(3,4), "invalidname", 2))
})
