% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flnl.constr.grad.R
\name{flnl.constr.grad.neg}
\alias{flnl.constr.grad.neg}
\title{(Negative) gradients of constraint function}
\usage{
flnl.constr.grad.neg(pars, ddfobj, misc.options, fitting = "all")
}
\arguments{
\item{pars}{vector of parameter values for the detection function at which 
the gradients of the negative log-likelihood should be evaluated}

\item{ddfobj}{distance sampling object}

\item{misc.options}{a list object containing all additional information such 
as the type of optimiser or the truncation width, and is created within
\code{ddf.ds}}

\item{fitting}{character string with values "all", "key", "adjust" to
determine which parameters are allowed to vary in the fitting. Not actually
used. Defaults to "all".}
}
\value{
a matrix of gradients for all constraints (rows) w.r.t to every
parameters (columns)
}
\description{
The function derives the gradients of the constraint function for 
all model parameters, in the following order:
1. Scale parameter (if part of key function)
2. Shape parameter (if part of key function)
3. Adjustment parameter 1
4. Adjustment parameter 2
5. Etc.
}
\details{
The constraint function itself is formed of a specified number of non-linear
constraints, which defaults to 20 and is specified through 
\code{misc.options$mono.points}. The constraint function checks whether the 
standardised detection function is 1) weakly/strictly monotonic at the 
points and 2) non-negative at all the points. \code{flnl.constr.grad} returns 
the gradients of those constraints w.r.t. all parameters of the detection
function, i.e., 2 times \code{mono.points} gradients for every parameter. 

This function mostly follows the same structure as \code{flnl.constr} in 
\code{detfct.fit.mono.R}.
}
