% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MQE_genEffects.R
\name{MQE_gen_effects}
\alias{MQE_gen_effects}
\title{QTL genetic effects multi-QTL effect model}
\usage{
MQE_gen_effects(mppData = NULL, trait = 1, QTL = NULL, Q.eff, ref.par = NULL)
}
\arguments{
\item{mppData}{An object of class \code{mppData}}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{QTL}{Vector of \code{character} markers positions
names. Default = NULL.}

\item{Q.eff}{\code{Character} vector indicating for each QTL position the
type of QTL effect among: "cr", "par", "anc" and "biall". For details look at
\code{\link{mpp_SIM}}.}

\item{ref.par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. For the
ancestral model, the ancestral class containing the reference parent will be
set as reference. \strong{This option can only be used if the MPP design is
composed of a unique connected part}. Default = NULL.}
}
\value{
Return:

\item{results}{\code{List} of \code{data.frame} (one per QTL) containing the
following information:

\enumerate{

\item{QTL genetic effects per cross or parent.}
\item{Standard error of the QTL effects.}
\item{Test statistics of the effects (t-test or Wald statistic).}
\item{P-value of the test statistics.}
\item{Significance of the QTL effects.}
\item{For cross-specific model, parent with the positive additive effects.}
\item{For parental and ancestral model, indicator of connected part of the
design and reference.}
\item{Allele scores of the parents if \code{geno.par} is non NULL
in the \code{mppData} object.}

  }

}
}
\description{
Compute a multi-QTL model with a list of QTL candidates (\code{QTL}) and return
the decomposed QTL genetic effects per cross or per parents. The list of QTL
can be of different types (cross-specific, parental, ancestral or bi-allelic).
The type of QTL effects are specified in the vector \code{Q.eff}.
}
\details{
This function computes for each QTL position the genetic effects of the
cross, parental, ancestral or SNP allele components. For the cross-specific
model (\code{Q.eff = "cr"}), the genetics effects represent the substitution
effect of an single allele from the parent 2 (or B) with respect to an allele
coming from the parent 1 or A. All effects are given in absolute value with
the parent that cary the positive allele.

For the parental and the ancestral model (\code{Q.eff = "par" or "anc"}), the
reference allele is defined per interconneted part. The most frequent
parental (ancestral) allele is set as reference. Effects of the other alleles
are estimated as deviation with respect to the reference. For more details
about reference definition see \code{\link{QTL_gen_effects}} and
\code{\link{design_connectivity}}.

For the bi-allelic model (\code{Q.eff = "biall"}), the genetic effects
represent the effects of a single allele copy of the least frequent allele.
}
\examples{

data(mppData)

SIM <- mpp_SIM(mppData = mppData)
QTL <- QTL_select(SIM)

QTL.eff <- MQE_gen_effects(mppData = mppData, QTL = QTL[, 1],
                          Q.eff = c("anc", "par", "biall"))

}
\seealso{
\code{\link{MQE_proc}}, \code{\link{mpp_SIM}},
\code{\link{QTL_gen_effects}}, \code{\link{design_connectivity}}
}
\author{
Vincent Garin
}
