% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{induced_level_subgraph}
\alias{induced_level_subgraph}
\title{Returns subgraph induced by one level of the network}
\usage{
induced_level_subgraph(net, level, lvl_attr = "sesType")
}
\arguments{
\item{net}{the network}

\item{level}{the (number of the) level}

\item{lvl_attr}{name of the nodal attribute specifying the level}
}
\value{
induced subgraph as \code{network} object.
}
\description{
This function is intended to be used together with \code{simulate_baseline()}
for partial ERGM models. Currently, only \code{network} objects are supported
as input.
}
\examples{

subgraph_actors <- induced_level_subgraph(motifr::ml_net, 1)
plot_mnet(subgraph_actors, label = TRUE)
}
