% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EbolaAll.R
\docType{data}
\name{EbolaAll}
\alias{EbolaAll}
\alias{EbolaGuinea}
\title{Case numbers in an Ebola outbreak in 2014}
\format{
A dataframe with 182 rows. Each row is a daily report
during a period of over 18 months during 2014 and 2015.
Each report gives the number of new cases and disease-related
deaths since the last report in each or three countries:
Sierra Leon, Liberia, and Guinea. These values have been calculated
from the raw, cumulative data. The data have been scrubbed to remove
obvious errors.
\itemize{
\item \code{Date}: Date when the World Health Organization issued the report
\item \code{Gcases}:  Number of new cases in Guinea
\item \code{Gdeaths}: Number of new deaths in Guinea
\item \code{Lcases}: Number of new cases in Liberia
\item \code{Ldeaths}: Number of new deaths in Liberia
\item \code{SLcases}: Number of new cases in Sierra Leone
\item \code{SLdeaths}: Number of new deaths in Sierra Leone
\item \code{TotCases}: Cumulative number of cases across all three countries
\item \code{TotDeaths}: Cumulative number of deaths across all three countries
Added in \code{EbolaGuinea}
\item \code{Days}: When the report was issued in terms of a count of days from the initial report.
\item \code{G7Rcases}:  Number of new cases in Guinea averaged across 7 reports
\item \code{G7Rdeaths}:  Number of new deaths in Guinea averaged across 7 reports
}

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 182 rows and 6 columns.
}
\source{
US Centers for Disease Control (CDC).
}
\usage{
EbolaAll

EbolaGuinea
}
\description{
In December 2013, an 18-month-old boy from a village in Guinea suffered fatal diarrhea.  Over the next months a broader outbreak was discovered, and in mid-March 2014, the Pasteur Institute in France confirmed the illness as Ebola-Virus Disease caused by the Zaire ebolavirus.
Although the outbreak was first recognized in Guinea,
it eventually encompassed Liberia and Sierra Leone
as well.  By July 2014, the outbreak spread to the
capitals of all three countries.
}
\details{
\itemize{
\item \code{EbolaAll} gives daily reports for Guinea, Liberia, and Sierra Leone.
\item \code{EbolaGuinea} contains just the Guinea data, but adds
columns containing a 7-day moving average.
}
}
\keyword{datasets}
