% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopwords.R
\name{languages}
\alias{languages}
\title{Returns ISO codes and names for all language or only those available in this package}
\usage{
languages(available = TRUE)
}
\arguments{
\item{available}{\emph{logical}, whether to return only the languages supported in this package.}
}
\value{
A data frame with a row for each languages (only those supported if \code{available} is \code{TRUE}) and columns for the several ISO codes (639-2, 639-3, 639-1) and the name.
}
\description{
See the relevant \href{https://en.wikipedia.org/wiki/ISO_639-1}{Wikipedia article} for details on the language codes.
}
\details{
Note that: \itemize{
 \item the ISO 639-1 code for mainland Chinese was changed to \code{zh-cn}.
 \item A list of stop words in the variety of Chinese spoken in the island of Taiwan is accessible using the ISO 639-1 \code{zh-tw} or the name \code{'Chinese Taiwan'}.
 \item Ancient Greek has been assigned an artifact ISO 639-1 code (\code{gr}) because it had none. Its ISO 639-2 and 639-3 codes are both \code{grc}.
}
}
\examples{
# Return all languages in the ISO 639-2/3 standard
languages()
}
