% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelObjFit.R
\docType{class}
\name{modelObjFit-class}
\alias{modelObjFit-class}
\alias{coef,modelObjFit-method}
\alias{plot,modelObjFit-method}
\alias{print,modelObjFit-method}
\alias{residuals,modelObjFit-method}
\alias{show,modelObjFit-method}
\alias{summary,modelObjFit-method}
\title{Class \code{modelObjFit}}
\usage{
\S4method{coef}{modelObjFit}(object, ...)

\S4method{plot}{modelObjFit}(x, y, ...)

\S4method{print}{modelObjFit}(x)

\S4method{residuals}{modelObjFit}(object, ...)

\S4method{show}{modelObjFit}(object)

\S4method{summary}{modelObjFit}(object, ...)
}
\arguments{
\item{object}{An object of class modelObjFit}

\item{...}{passed to underlying method defined for regression value object.}

\item{x}{An object of class modelObjFit}

\item{y}{ignored}
}
\description{
A class for storing regression analysis results.
}
\section{Methods (by generic)}{
\itemize{
\item \code{coef(modelObjFit)}: Extract Model Coefficients

\item \code{plot(modelObjFit)}: X-Y plotting

\item \code{print(modelObjFit)}: Print regression results

\item \code{residuals(modelObjFit)}: Extract residuals

\item \code{show(modelObjFit)}: Show regression results

\item \code{summary(modelObjFit)}: Show summary results

}}
\section{Slots}{

\describe{
\item{\code{fitObj}}{Object returned by the regression analysis}

\item{\code{modelObj}}{Object of class \code{modelObj}.}
}}

\section{Methods}{

  \describe{
    \item{fitObject}{: Extracts regression step. }
    \item{model}{: Retrieve model. }
    \item{solver}{: Retrieve regression method name. }
    \item{solverArgs}{: Retrieve arguments to be sent to regression method. }
    \item{solverArgs(object)<-}{: Set arguments to be sent to regression method. }
    \item{predictor}{: Retrieve prediction method name. }
    \item{predictorArgs}{: Retrieve arguments to be sent to prediction method. }
    \item{predictorArgs(object)<-}{: Set arguments to be sent to prediction method. }
  }
}

\examples{
showClass("modelObjFit")

}
