% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr_boxplots.R
\name{calc_div}
\alias{calc_div}
\title{Compute various diversity indices from a vector of species abundances (i.e.,
one row of a community matrix)}
\usage{
calc_div(
  x,
  index,
  effort = NA,
  rare_thres = 0.05,
  replace = FALSE,
  C_target = NULL,
  extrapolate = TRUE,
  ...
)
}
\arguments{
\item{x}{is a vector of species abundances}

\item{index}{The calculated biodiversity indices. The options are
\itemize{
   \item \code{N} ... Number of individuals (total abundance)
   \item \code{S} ... Number of species
   \item \code{S_n} ... Rarefied or extrapolated number of species for n individuals
   \item \code{S_C} ... Estimate species richness of a given level of coverage by \code{C_target_gamma}
   \item \code{S_asymp} ... Estimated asymptotic species richness
   \item \code{f_0} ... Estimated number of undetected species 
   \item \code{pct_rare} ... The percent of rare species as defined by \code{rare_thres}
   \item \code{PIE} ... Hurlbert's PIE (Probability of Interspecific Encounter)
   \item \code{S_PIE} ... Effective number of species based on PIE
   
}
  See \emph{Details} for additional information on the
  biodiversity statistics.}

\item{effort}{The standardized number of individuals used for the 
calculation of rarefied species richness. This can a be
single integer or a vector of integers.}

\item{rare_thres}{The threshold that determines how pct_rare is computed.
It can range from (0, 1] and defaults to 0.05 which specifies that any 
species with less than or equal to 5% of the total abundance in a sample is
considered rare. It can also be specified as "N/S" which results in using
average abundance as the threshold which McGill (2011) found to have the 
best small sample behavior.}

\item{replace}{Used for \code{PIE} and \code{SPIE}.  If TRUE, sampling with
replacement is used. Otherwise, sampling without replacement (default).}

\item{C_target}{When computing coverage based richness (\code{S_C}) then 
this argument can be used to specify the coverage to be used for the richness
estimate. This defaults to \code{NA} in which case the target cover
is computed by \code{\link{calc_C_target}} (i.e., the largest allowable sample
size).}

\item{extrapolate}{Boolean which specifies if richness should be extrapolated
when effort is larger than the number of individuals using the chao1
method.}

\item{...}{additional arguments that can be passed to the function
\code{rarefaction} when computing \code{S_n}.}
}
\description{
Compute various diversity indices from a vector of species abundances (i.e.,
one row of a community matrix)
}
\examples{
 
data(inv_tank)
calc_div(tank_comm[1, ], 'S_n', effort = c(5, 10))
calc_div(tank_comm[1, ], 'S_C', C_target = 0.9)
}
