% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_im_glmrob.R
\name{cluster_im_glmRob}
\alias{cluster_im_glmRob}
\title{Cluster-Adjusted Confidence Intervals And p-Values Robust GLMs}
\usage{
cluster_im_glmRob(
  robmod,
  dat,
  cluster,
  ci.level = 0.95,
  drop = TRUE,
  return.vcv = FALSE,
  engine = "robust",
  ...
)
}
\arguments{
\item{robmod}{A robust generalized linear model object created using
robust::glmRob() or robustbase::glmrob(). It must contain
elements 'formula', 'family', and 'method'.}

\item{dat}{A data frame containing the data used in the model.}

\item{cluster}{A formula indicating the clustering variable in \code{dat}.}

\item{ci.level}{Confidence level for the confidence intervals, default is 0.95.}

\item{drop}{Logical; if TRUE, drops clusters where the model does not converge.}

\item{return.vcv}{Logical; if TRUE, the variance-covariance matrix of the
cluster-averaged coefficients will be returned.}

\item{engine}{Set the engine to "robust" to use robust::glmRob() or "robustbase"
to use robustbase::glmrob(). Default is "robust".}

\item{...}{Additional arguments to be passed to \code{robust::glmRob()} or
\code{robustbase::glmrob()}.}
}
\value{
An invisible list containing the following elements:
\describe{
\item{p.values}{A matrix of p-values for each independent variable.}
\item{ci}{A matrix with the lower and upper bounds of the confidence intervals
for each independent variable.}
\item{vcv.hat}{The variance-covariance matrix of the cluster-averaged
coefficients, returned if \code{return.vcv} is TRUE.}
\item{beta.bar}{The cluster-averaged coefficients, returned if \code{return.vcv}
is TRUE.}
}
}
\description{
Performs cluster-adjusted inference on a robust generalized linear model object,
using robust generalized linear regression within each cluster. This function is
tailored for models where observations are clustered, and standard errors
need adjustment for clustering. The function applies a robust generalized
linear regression model to each cluster using the specified family and method,
and then aggregates the results.
}
\examples{
iris_bin <- iris
# Create a binary variable for MPG (e.g., MPG > 20)
iris_bin$high_Sepal.Length = as.factor(ifelse(iris_bin$Sepal.Length > 5.8, 1, 0))

robout <- robustbase::glmrob(formula = high_Sepal.Length ~ Petal.Length + Petal.Width,
                             family = binomial,
                             data = iris_bin)
cluster_im_glmRob(robout, dat = iris_bin, ~Species, return.vcv = TRUE,
                  engine = "robustbase")

}
