% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleTable-methods-exported.R
\name{SingleTable.create}
\alias{SingleTable.create}
\title{Create an object of class \code{singletable}.}
\usage{
SingleTable.create(a1,b1,a2,b2,rho,y1,n1,y2,n2,model,measure)
}
\arguments{
\item{a1}{a numeric value specifying the first hyperparameter of the beta prior for group 1.}

\item{b1}{a numeric value specifying the second hyperparameter of the beta prior for group 1.}

\item{a2}{a numeric value specifying the first hyperparameter of the beta prior for group 2.}

\item{b2}{a numeric value specifying the second hyperparameter of the beta prior for group 2.}

\item{rho}{a numeric value specifying correlation coefficient for Sarmanov bivariate prior distribution.}

\item{y1}{an integer indicating the number of events in group 1.}

\item{n1}{an integer indicating the total number of subjects in group 1.}

\item{y2}{an integer indicating the number of events in group 2.}

\item{n2}{an integer indicating the total number of subjects in group 2.}

\item{model}{a character string specifying the model. Options are \code{Independent} and \code{Sarmanov}. \code{Independent} is
independent beta-binomial model. \code{Sarmanov}is Sarmanov beta-binomial model.}

\item{measure}{a character string specifying a measure. Options are
\code{OR}, \code{RR}, and \code{RD}. \code{OR} is odds
 ratio, \code{RR} is relative risk, and \code{RD} is risk difference.}
}
\value{
An object is returned, inheriting from class \code{singletable}.
The Objects of this class contain the meta-data for generic functions: \code{SingleTable.modelFit},
\code{SingleTable.summary}, and \code{SingleTable.plot}. The following values
of the object must be non-null under \code{SingleTable.create}:
\item{measure}{the value of \code{measure} argument.}
\item{model}{the value of \code{model} argument.}
\item{data}{a numeric vector of input data with components: \code{y1}, \code{n1}, \code{y2}, \code{n2}}
\item{parameter}{a numeric vector of the hyperparameters: \code{a1}, \code{b1}, \code{a2}, \code{b2}, and \code{rho}.}
}
\description{
Create an object of class \code{SingleTable}, which is
a components list of exact posterior inference based on single 2x2 table.
}
\details{
There are two kinds of study design, i.e., prospective study or
clinical trial, and retrospective or case-control study.
In a prospective study or clinical trial, \code{data} is a data
frame that contains \code{y1}, \code{n1}, \code{y2}, \code{n2}.
\code{y1} is the number of subjects
experienced a certain event in the unexposed group. \code{n1} is the number
of subjects in the unexposed group. \code{y2} is the number of subjects experienced
a certain event in the exposed group. \code{n2} is the number of
subjects in the exposed group. In this study, \code{OR} is odds ratio
of event comparing exposed group with unexposed group. \code{RR}
is relative risk of event comparing exposed group with unexposed group. \code{RD} is risk
difference of event comparing exposed group with unexposed group.

For case-control study, \code{y1} is the number of subjects with
exposure in the control group. \code{n1} is the number of
subjects in the control group. \code{y2} is the number of
subjects with exposure in the case group. \code{n2} is the
number of subjects in the case group. In this study, \code{OR} is odds ratio
of event comparing case group with control group. \code{RR} is
relative risk of event comparing case group with control group. \code{RD} is risk
difference of event comparing case group with control group.
When model='\code{Sarmanov}', \code{rho} is subject to constraints. See Chen et al(2011) for details.
}
\examples{
## Specify data (y1, n1, y2, n2), parameters (a1, b1, a2, b2, rho), model (Sarmanov/Independent),
## and Specify measure(OR/RR/RD)
## Assume we have a 2x2 table:{{40,56},{49,60}} and set prior parameters as a1=b1=a2=b2=rho=0.5.
## Create object \code{single_table_obj}
 \donttest{
 library(mmeta)
 library(ggplot2)
 single_table_obj <- SingleTable.create(a1=0.5,b1=0.5,
 a2=0.5,b2=0.5,rho=0.5, y1=40, n1=96, y2=49, n2=109,model="Sarmanov",measure="OR")}
}
\references{
Chen, Y., Luo, S., (2011a). A Few Remarks on "Statistical Distribution of the Difference of
Two Proportions' by Nadarajah and Kotz, Statistics in Medicine 2007; 26(18):3518-3523". \cr
\emph{Statistics in Medicine, 30(15)}, 1913-1915. \cr
<doi:10.1002/sim.4248> \cr
}
\seealso{
\code{SingleTable.modelFit}, \code{SingleTable.summary}, \code{SingleTable.plot}.
}
