% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmaqshiny-package.R
\docType{package}
\name{mmaqshiny-package}
\alias{mmaqshiny}
\alias{mmaqshiny-package}
\title{mmaqshiny: Explore Air-Quality Mobile-Monitoring Data}
\description{
Mobile-monitoring or "sensors on a mobile platform", is an increasingly 
    popular approach to measure high-resolution pollution data at the street level. 
    Coupled with location data, spatial visualisation of air-quality parameters 
    helps detect localized areas of high air-pollution, also called hotspots. 
    In this approach, portable sensors are mounted on a vehicle and driven on 
    predetermined routes to collect high frequency data (1 Hz). 
    'mmaqshiny' is for analysing, visualising and spatial mapping of 
    high-resolution air-quality data collected by specific devices installed on 
    a moving platform. 1 Hz data of PM2.5 (mass concentrations of particulate  
    matter with size less than 2.5 microns), Black carbon mass concentrations 
    (BC), ultra-fine particle number concentrations, carbon dioxide along with 
    GPS coordinates and relative humidity (RH) data collected by popular 
    portable instruments (TSI DustTrak-8530, Aethlabs microAeth-AE51, TSI CPC3007, 
    LICOR Li-830, Garmin GPSMAP 64s, Omega USB RH probe respectively). It 
    incorporates device specific cleaning and correction algorithms. RH correction 
    is applied to DustTrak PM2.5 following the Chakrabarti et al., (2004) 
    <doi:10.1016/j.atmosenv.2004.03.007>. Provision is given to add linear 
    regression coefficients for correcting the PM2.5 data (if required). BC data
    will be cleaned for the vibration generated noise, by adopting the statistical 
    procedure as explained in Apte et al., (2011) <doi:10.1016/j.atmosenv.2011.05.028>, 
    followed by a loading correction as suggested by Ban-Weiss et al., (2009)  
    <doi:10.1021/es8021039>. For the number concentration data, provision is 
    given for dilution correction factor (if a diluter is used with CPC3007; 
    default value is 1). The package joins the raw, cleaned and corrected data 
    from the above said instruments and outputs as a downloadable csv file.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/meenakshi-kushwaha/mmaqshiny}
  \item Report bugs at \url{https://github.com/meenakshi-kushwaha/mmaqshiny/issues}
}

}
\author{
\strong{Maintainer}: Adithi R. Upadhya \email{adithi@ilklabs.com} [copyright holder]

Authors:
\itemize{
  \item Meenakshi Kushwaha \email{meenakshi@ilklabs.com} [copyright holder]
}

Other contributors:
\itemize{
  \item Pratyush Agrawal \email{pratyush@ilklabs.com} [data contributor]
  \item Sreekanth Vakacherla \email{sree.hcu@gmail.com} [author of introduction, etc., contributor]
}

}
\keyword{internal}
