% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArchiveAsyncTuning.R
\name{ArchiveAsyncTuning}
\alias{ArchiveAsyncTuning}
\title{Rush Data Storage}
\description{
The `ArchiveAsyncTuning`` stores all evaluated hyperparameter configurations and performance scores in a \link[rush:Rush]{rush::Rush} database.
}
\details{
The \link{ArchiveAsyncTuning} is a connector to a \link[rush:Rush]{rush::Rush} database.
}
\section{Data Structure}{


The table (\verb{$data}) has the following columns:
\itemize{
\item One column for each hyperparameter of the search space (\verb{$search_space}).
\item One (list-)column for the \code{internal_tuned_values}
\item One column for each performance measure (\verb{$codomain}).
\item \code{x_domain} (\code{list()})\cr
Lists of (transformed) hyperparameter values that are passed to the learner.
\item \code{runtime_learners} (\code{numeric(1)})\cr
Sum of training and predict times logged in learners per \link[mlr3:ResampleResult]{mlr3::ResampleResult} / evaluation.
This does not include potential overhead time.
\item \code{timestamp} (\code{POSIXct})\cr
Time stamp when the evaluation was logged into the archive.
\item \code{batch_nr} (\code{integer(1)})\cr
Hyperparameters are evaluated in batches.
Each batch has a unique batch number.
}
}

\section{Analysis}{

For analyzing the tuning results, it is recommended to pass the \link{ArchiveAsyncTuning} to \code{as.data.table()}.
The returned data table contains the \link[mlr3:ResampleResult]{mlr3::ResampleResult} for each hyperparameter evaluation.
}

\section{S3 Methods}{

\itemize{
\item \code{as.data.table.ArchiveTuning(x, unnest = "x_domain", exclude_columns = "uhash", measures = NULL)}\cr
Returns a tabular view of all evaluated hyperparameter configurations.\cr
\link{ArchiveAsyncTuning} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
\itemize{
\item \code{x} (\link{ArchiveAsyncTuning})
\item \code{unnest} (\code{character()})\cr
Transforms list columns to separate columns. Set to \code{NULL} if no column should be unnested.
\item \code{exclude_columns} (\code{character()})\cr
Exclude columns from table. Set to \code{NULL} if no column should be excluded.
\item \code{measures} (List of \link[mlr3:Measure]{mlr3::Measure})\cr
Score hyperparameter configurations on additional measures.
}
}
}

\section{Super classes}{
\code{\link[bbotk:Archive]{bbotk::Archive}} -> \code{\link[bbotk:ArchiveAsync]{bbotk::ArchiveAsync}} -> \code{ArchiveAsyncTuning}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{internal_search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
The search space containing those parameters that are internally optimized by the \code{\link[mlr3:Learner]{mlr3::Learner}}.}

\item{\code{benchmark_result}}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
Benchmark result.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ArchiveAsyncTuning-new}{\code{ArchiveAsyncTuning$new()}}
\item \href{#method-ArchiveAsyncTuning-learner}{\code{ArchiveAsyncTuning$learner()}}
\item \href{#method-ArchiveAsyncTuning-learners}{\code{ArchiveAsyncTuning$learners()}}
\item \href{#method-ArchiveAsyncTuning-learner_param_vals}{\code{ArchiveAsyncTuning$learner_param_vals()}}
\item \href{#method-ArchiveAsyncTuning-predictions}{\code{ArchiveAsyncTuning$predictions()}}
\item \href{#method-ArchiveAsyncTuning-resample_result}{\code{ArchiveAsyncTuning$resample_result()}}
\item \href{#method-ArchiveAsyncTuning-print}{\code{ArchiveAsyncTuning$print()}}
\item \href{#method-ArchiveAsyncTuning-clone}{\code{ArchiveAsyncTuning$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="format"><a href='../../bbotk/html/Archive.html#method-Archive-format'><code>bbotk::Archive$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="help"><a href='../../bbotk/html/Archive.html#method-Archive-help'><code>bbotk::Archive$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="best"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-best'><code>bbotk::ArchiveAsync$best()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="clear"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-clear'><code>bbotk::ArchiveAsync$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="data_with_state"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-data_with_state'><code>bbotk::ArchiveAsync$data_with_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="nds_selection"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-nds_selection'><code>bbotk::ArchiveAsync$nds_selection()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="pop_point"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-pop_point'><code>bbotk::ArchiveAsync$pop_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="push_failed_point"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-push_failed_point'><code>bbotk::ArchiveAsync$push_failed_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="push_points"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-push_points'><code>bbotk::ArchiveAsync$push_points()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="push_result"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-push_result'><code>bbotk::ArchiveAsync$push_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="push_running_point"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-push_running_point'><code>bbotk::ArchiveAsync$push_running_point()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuning-new"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuning-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuning$new(
  search_space,
  codomain,
  rush,
  internal_search_space = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Hyperparameter search space. If \code{NULL} (default), the search space is
constructed from the \link[paradox:to_tune]{paradox::TuneToken} of the learner's parameter set
(learner$param_set).}

\item{\code{codomain}}{(\link[bbotk:Codomain]{bbotk::Codomain})\cr
Specifies codomain of objective function i.e. a set of performance measures.
Internally created from provided \link[mlr3:Measure]{mlr3::Measure}s.}

\item{\code{rush}}{(\code{Rush})\cr
If a rush instance is supplied, the tuning runs without batches.}

\item{\code{internal_search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet} or \code{NULL})\cr
The internal search space.}

\item{\code{check_values}}{(\code{logical(1)})\cr
If \code{TRUE} (default), hyperparameter configurations are check for validity.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuning-learner"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuning-learner}{}}}
\subsection{Method \code{learner()}}{
Retrieve \link[mlr3:Learner]{mlr3::Learner} of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
Learner does not contain a model. Use \verb{$learners()} to get learners with models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuning$learner(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuning-learners"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuning-learners}{}}}
\subsection{Method \code{learners()}}{
Retrieve list of trained \link[mlr3:Learner]{mlr3::Learner} objects of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuning$learners(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuning-learner_param_vals"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuning-learner_param_vals}{}}}
\subsection{Method \code{learner_param_vals()}}{
Retrieve param values of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuning$learner_param_vals(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuning-predictions"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuning-predictions}{}}}
\subsection{Method \code{predictions()}}{
Retrieve list of \link[mlr3:Prediction]{mlr3::Prediction} objects of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuning$predictions(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuning-resample_result"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuning-resample_result}{}}}
\subsection{Method \code{resample_result()}}{
Retrieve \link[mlr3:ResampleResult]{mlr3::ResampleResult} of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuning$resample_result(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuning-print"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuning-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuning$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuning-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuning-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuning$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
