% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcqFunctionStochasticEI.R
\name{mlr_acqfunctions_stochastic_ei}
\alias{mlr_acqfunctions_stochastic_ei}
\alias{AcqFunctionStochasticEI}
\title{Acquisition Function Stochastic Expected Improvement}
\description{
Expected Improvement with epsilon decay.
\eqn{\epsilon} is updated after each update by the formula \code{epsilon * exp(-rate * (t \%\% period))} where \code{t} is the number of times the acquisition function has been updated.

While this acquisition function usually would be used within an asynchronous optimizer, e.g., \link{OptimizerAsyncMbo},
it can in principle also be used in synchronous optimizers, e.g., \link{OptimizerMbo}.
}
\section{Dictionary}{

This \link{AcqFunction} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_acqfunctions} or with the associated sugar function \code{\link[=acqf]{acqf()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_acqfunctions$get("stochastic_ei")
acqf("stochastic_ei")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\itemize{
\item \code{"epsilon"} (\code{numeric(1)})\cr
\eqn{\epsilon} value used to determine the amount of exploration.
Higher values result in the importance of improvements predicted by the posterior mean
decreasing relative to the importance of potential improvements in regions of high predictive uncertainty.
Defaults to \code{0.1}.
\item \code{"rate"} (\code{numeric(1)})\cr
Defaults to \code{0.05}.
\item \code{"period"} (\code{integer(1)})\cr
Period of the exponential decay.
Defaults to \code{NULL}, i.e., the decay has no period.
}
}

\section{Note}{

\itemize{
\item This acquisition function always also returns its current (\code{acq_epsilon}) and original (\code{acq_epsilon_0}) \eqn{\epsilon}.
These values will be logged into the \link[bbotk:ArchiveBatch]{bbotk::ArchiveBatch} of the \link[bbotk:OptimInstanceBatch]{bbotk::OptimInstanceBatch} of the \link{AcqOptimizer} and
therefore also in the \link[bbotk:Archive]{bbotk::Archive} of the actual \link[bbotk:OptimInstance]{bbotk::OptimInstance} that is to be optimized.
}
}

\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)
  library(data.table)

  fun = function(xs) {
    list(y = xs$x ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceBatchSingleCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  instance$eval_batch(data.table(x = c(-6, -5, 3, 9)))

  learner = default_gp()

  surrogate = srlrn(learner, archive = instance$archive)

  acq_function = acqf("stochastic_ei", surrogate = surrogate)

  acq_function$surrogate$update()
  acq_function$update()
  acq_function$eval_dt(data.table(x = c(-1, 0, 1)))
}
}
\references{
\itemize{
\item Jones, R. D, Schonlau, Matthias, Welch, J. W (1998).
\dQuote{Efficient Global Optimization of Expensive Black-Box Functions.}
\emph{Journal of Global optimization}, \bold{13}(4), 455--492.
}
}
\seealso{
Other Acquisition Function: 
\code{\link{AcqFunction}},
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_acqfunctions_aei}},
\code{\link{mlr_acqfunctions_cb}},
\code{\link{mlr_acqfunctions_ehvi}},
\code{\link{mlr_acqfunctions_ehvigh}},
\code{\link{mlr_acqfunctions_ei}},
\code{\link{mlr_acqfunctions_ei_log}},
\code{\link{mlr_acqfunctions_eips}},
\code{\link{mlr_acqfunctions_mean}},
\code{\link{mlr_acqfunctions_multi}},
\code{\link{mlr_acqfunctions_pi}},
\code{\link{mlr_acqfunctions_sd}},
\code{\link{mlr_acqfunctions_smsego}},
\code{\link{mlr_acqfunctions_stochastic_cb}}
}
\concept{Acquisition Function}
\section{Super classes}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{\link[mlr3mbo:AcqFunction]{mlr3mbo::AcqFunction}} -> \code{AcqFunctionStochasticEI}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{y_best}}{(\code{numeric(1)})\cr
Best objective function value observed so far.
In the case of maximization, this already includes the necessary change of sign.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AcqFunctionStochasticEI-new}{\code{AcqFunctionStochasticEI$new()}}
\item \href{#method-AcqFunctionStochasticEI-update}{\code{AcqFunctionStochasticEI$update()}}
\item \href{#method-AcqFunctionStochasticEI-reset}{\code{AcqFunctionStochasticEI$reset()}}
\item \href{#method-AcqFunctionStochasticEI-clone}{\code{AcqFunctionStochasticEI$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_dt"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_dt'><code>mlr3mbo::AcqFunction$eval_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_many"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_many'><code>mlr3mbo::AcqFunction$eval_many()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionStochasticEI-new"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionStochasticEI-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionStochasticEI$new(
  surrogate = NULL,
  epsilon = 0.1,
  rate = 0.05,
  period = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate}}{(\code{NULL} | \link{SurrogateLearner}).}

\item{\code{epsilon}}{(\code{numeric(1)}).}

\item{\code{rate}}{(\code{numeric(1)}).}

\item{\code{period}}{(\code{NULL} | \code{integer(1)}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionStochasticEI-update"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionStochasticEI-update}{}}}
\subsection{Method \code{update()}}{
Update the acquisition function.
Sets \code{y_best} to the best observed objective function value.
Decays epsilon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionStochasticEI$update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionStochasticEI-reset"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionStochasticEI-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the acquisition function.
Resets the private update counter \code{.t} used within the epsilon decay.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionStochasticEI$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionStochasticEI-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionStochasticEI-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionStochasticEI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
