% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grake.R
\name{gginv}
\alias{gginv}
\title{Generalized Inverse of a Matrix using a custom tolerance or SVD implementation}
\usage{
gginv(tol = sqrt(.Machine$double.eps), svd = base::svd)
}
\arguments{
\item{tol}{
A relative tolerance to detect zero singular values.
}

\item{svd}{A function that computes the singular value decomposition of a
matrix}
}
\value{
A function that accepts one argument \code{X} that computes a MP
generalized inverse matrix for it.
}
\description{
The \code{gginv} function creates a function that
calculates the Moore-Penrose generalized inverse of a matrix X using a
fixed tolerance value and a custom
implementation for computing the singular value decomposition.
}
\details{
The \code{svd} argument is expected to adhere to the interface of
\code{\link[base:svd]{base::svd()}}. It will be called as \code{svd(x)} (with the
\code{nu} and \code{nv} arguments unset) and is expected to return a named
list with components \code{d}, \code{u} and \code{v}.
}
\seealso{
\code{\link[MASS:ginv]{MASS::ginv()}}, \code{\link[base:svd]{base::svd()}}
}
\author{
Adapted implementation from the \code{MASS} package.
}
