% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_LS_gene.R
\name{impute_LS_gene}
\alias{impute_LS_gene}
\title{LSimpute_gene}
\usage{
impute_LS_gene(
  ds,
  k = 10,
  eps = 1e-06,
  min_common_obs = 5,
  return_r_max = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{k}{Number of most correlated genes used for the imputation of a gene.}

\item{eps}{Used in the calculation of the weights (Bo et al. (2004) used
\code{eps = 1e-6}).}

\item{min_common_obs}{A row can only take part in the imputation of another
row, if both rows share at least \code{min_common_obs} columns with no missing
values.}

\item{return_r_max}{Logical; normally, this should be \code{FALSE}. \code{TRUE} is
used inside of \code{impute_LS_adaptive()} to speed up some computations.}

\item{verbose}{Should messages be given for special cases (see details)?}
}
\value{
An object of the same class as \code{ds} with imputed missing values.

If \code{return_r_max = TRUE}, a list with the imputed dataset and r_max.
}
\description{
Perform LSimpute_gene as described by Bo et al. (2004)
}
\details{
This function performs LSimpute_gene as described by Bo et al. (2004).The function assumes that the genes are the rows of \code{ds}.

Bo et al. (2004) seem to have chosen \code{min_common_obs = 5}. However, they did
not document this behavior. This value emerged from inspecting
imputation results from the  original jar-file, which is provided by Bo et
al. (2004).

If there are less than \code{min_common_obs} observed values in a row and at least
one observed value, the mean of the observed row values is imputed. If no
value is observed in a row, the observed column means are imputed for the
missing row values. This is the only known difference between this function
and the original one from Bo et al. (2004). The original function would not
impute such a row and return a dataset with missing values in this row. There
is one more case that needs a special treatment: If no suitable row can be
found to impute a row, the mean of the observed values is imputed, too. If
\code{verbose = TRUE}, a message will be given for the encountered instances of
the described special cases. If \code{verbose = FALSE}, the function will deal
with theses cases silently.
}
\examples{
set.seed(123)
ds_mis <- delete_MCAR(mvtnorm::rmvnorm(100, rep(0, 10)), 0.1)
ds_imp <- impute_LS_gene(ds_mis)
}
\references{
Bo, T. H., Dysvik, B., & Jonassen, I. (2004). LSimpute: accurate estimation of missing values in microarray data with least squares methods. Nucleic acids research, 32(3), e34
}
\seealso{
Other LSimpute functions: 
\code{\link{impute_LS_adaptive}()},
\code{\link{impute_LS_array}()},
\code{\link{impute_LS_combined}()}
}
\concept{LSimpute functions}
