% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_sensitivity.R
\name{lr_sensitivity}
\alias{lr_sensitivity}
\title{Sensitivity Analysis for Likelihood Ratios}
\usage{
lr_sensitivity(
  evidence_type,
  param,
  range = NULL,
  steps = 20,
  match = TRUE,
  baseline = NULL
)
}
\arguments{
\item{evidence_type}{Character. Type of evidence to analyze.
Options: "sex", "age", "hair", "region".}

\item{param}{Character. Parameter to vary. Options depend on evidence_type:
\itemize{
\item \code{"sex"}: "eps" (error rate), "freq" (population frequency)
\item \code{"age"}: "eps" (error rate), "range" (age interval)
\item \code{"hair"}: "eps" (error rate), "freq" (population frequency)
\item \code{"region"}: "eps" (error rate), "nreg" (number of regions)
}}

\item{range}{Numeric vector of length 2. Range of parameter values to test.
Default depends on param type.}

\item{steps}{Integer. Number of steps in the range. Default: 20.}

\item{match}{Logical. TRUE for matching evidence (same sex/age in range/etc),
FALSE for mismatching. Default: TRUE.}

\item{baseline}{List. Baseline parameter values. If NULL, uses defaults.}
}
\value{
A data.frame with columns:
\itemize{
\item \code{param_value}: Parameter value tested
\item \code{LR}: Resulting likelihood ratio
\item \code{log10_LR}: Log10 of LR (useful for plotting)
}
}
\description{
Evaluates how the likelihood ratio changes when model parameters vary.
This is essential for understanding the robustness of forensic conclusions
and for communicating uncertainty to decision-makers.
}
\details{
Sensitivity analysis is critical in forensic science because:
\enumerate{
\item Parameters (error rates, population frequencies) are often estimated
with uncertainty
\item Different reference populations may have different frequencies
\item The analysis reveals which parameters most affect conclusions
}

\strong{Interpretation:}
\itemize{
\item Steep curves indicate high sensitivity (conclusions depend strongly
on parameter choice)
\item Flat curves indicate robustness (conclusions stable across
reasonable parameter values)
}
}
\examples{
# How does sex LR change with error rate?
sens_eps <- lr_sensitivity("sex", param = "eps", range = c(0.01, 0.20))
plot(sens_eps$param_value, sens_eps$log10_LR, type = "l",
     xlab = "Error rate", ylab = "log10(LR)",
     main = "Sex LR sensitivity to error rate")
abline(h = 0, lty = 2)

# How does sex LR change with population frequency?
sens_freq <- lr_sensitivity("sex", param = "freq", range = c(0.3, 0.7))
plot(sens_freq$param_value, sens_freq$log10_LR, type = "l",
     xlab = "Female frequency", ylab = "log10(LR)",
     main = "Sex LR sensitivity to population frequency")

# Age LR sensitivity to range parameter
sens_range <- lr_sensitivity("age", param = "range", range = c(2, 15))
plot(sens_range$param_value, sens_range$log10_LR, type = "l",
     xlab = "Age range (+/- years)", ylab = "log10(LR)",
     main = "Age LR sensitivity to range")
}
\references{
Kling D, Tillmar AO, Egeland T (2014). "Familias 3-Extensions and new
functionality." \emph{Forensic Science International: Genetics}, 13, 121-127.
}
\seealso{
\code{\link{lr_sex}}, \code{\link{lr_age}}, \code{\link{lr_hair_color}}
for individual LR calculations.
}
