% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpt_population.R
\name{cpt_population}
\alias{cpt_population}
\title{Population-Based Conditional Probability Table}
\usage{
cpt_population(
  propS = c(0.5, 0.5),
  MPa = 40,
  MPr = 6,
  propC = c(0.3, 0.2, 0.25, 0.15, 0.1)
)
}
\arguments{
\item{propS}{Numeric vector of length 2. Sex proportions in the population,
specified as c(proportion_female, proportion_male). Must sum to 1.
Default: c(0.5, 0.5) for equal proportions.}

\item{MPa}{Numeric. Missing person's estimated age in years. Used to define
the center of the age matching interval. Default: 40.}

\item{MPr}{Numeric. Age range tolerance in years (plus/minus). The matching
age interval is \code{(MPa - MPr)} to \code{(MPa + MPr)}. Individuals within
this range are classified as T1 (age match), others as T0 (age mismatch).
Default: 6.}

\item{propC}{Numeric vector of length 5. Hair color proportions in the
population for colors 1 through 5. Must sum to 1. Default values represent
a typical distribution. Colors are: 1=Black, 2=Brown, 3=Blonde,
4=Red, 5=Gray/White.}
}
\value{
A 4x5 numeric matrix representing joint probabilities. Rows
correspond to sex-age group combinations:
\itemize{
\item F-T1: Female, age within range
\item F-T0: Female, age outside range
\item M-T1: Male, age within range
\item M-T0: Male, age outside range
}
Columns correspond to hair colors 1-5. Each cell contains
P(Sex, AgeGroup, HairColor | H2).
}
\description{
Computes a conditional probability table (CPT) representing the joint
probability distribution of sex, age group, and hair color in the reference
population. This table represents P(D|H2), the probability of observing
the evidence under the hypothesis that the unidentified person is NOT
the missing person.

The function assumes a uniform age distribution across the population
and computes the probability of falling within or outside the specified
age range.
}
\details{
The probability of age match (T1) is calculated assuming a uniform
distribution over ages 1-80:
\deqn{P(T1) = (MPa + MPr - (MPa - MPr)) / 80 = 2 \times MPr / 80}

The joint probability for each cell is:
\deqn{P(Sex, Age, Color) = P(Sex) \times P(AgeGroup) \times P(Color)}
}
\examples{
# Default parameters: equal sex proportions, MP age 40 +/- 6 years
cpt_h2 <- cpt_population()
print(cpt_h2)

# Custom population: 60\% female, narrower age range, different hair colors
cpt_custom <- cpt_population(
  propS = c(0.6, 0.4),
  MPa = 35,
  MPr = 3,
  propC = c(0.4, 0.25, 0.2, 0.1, 0.05)
)

# Verify rows sum correctly (should sum to hair color proportions)
colSums(cpt_h2)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{cpt_missing_person}} for the H1 conditional probability table,
\code{\link{plot_cpt}} for visualization of CPTs.
}
